/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.common.attributes;

import java.util.Collection;
import org.cryptimeleon.craco.common.attributes.Attribute;
import org.cryptimeleon.craco.common.policies.PolicyFact;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.annotations.AnnotatedUbrUtil;
import org.cryptimeleon.math.hash.annotations.UniqueByteRepresented;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.RepresentableRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.rings.Ring;
import org.cryptimeleon.math.structures.rings.RingElement;

public class RingElementAttribute
implements Attribute {
    @UniqueByteRepresented
    private RingElement element;

    public RingElementAttribute(RingElement element) {
        this.element = element;
    }

    public RingElementAttribute(Representation repr) {
        Ring ring = (Ring)repr.obj().get("ring").repr().recreateRepresentable();
        this.element = ring.restoreElement(repr.obj().get("elem"));
    }

    public RingElement getAttribute() {
        return this.element;
    }

    public Representation getRepresentation() {
        ObjectRepresentation result = new ObjectRepresentation();
        result.put("elem", this.element.getRepresentation());
        result.put("ring", (Representation)new RepresentableRepresentation((Representable)this.element.getStructure()));
        return result;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RingElementAttribute other = (RingElementAttribute)obj;
        return !(this.element == null ? other.element != null : !this.element.equals(other.element));
    }

    public String toString() {
        return this.element.toString();
    }

    @Override
    public boolean isFulfilled(Collection<? extends PolicyFact> facts) {
        return facts.contains(this);
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        return AnnotatedUbrUtil.autoAccumulate((ByteAccumulator)accumulator, (Object)this);
    }
}

