/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.common.policies;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cryptimeleon.craco.common.policies.Policy;
import org.cryptimeleon.craco.common.policies.PolicyFact;
import org.cryptimeleon.craco.secretsharing.accessstructure.exceptions.WrongAccessStructureException;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.annotations.AnnotatedUbrUtil;
import org.cryptimeleon.math.hash.annotations.UniqueByteRepresented;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;

public class BooleanPolicy
implements Policy {
    @UniqueByteRepresented
    @Represented
    private BooleanOperator operator;
    @UniqueByteRepresented
    @Represented
    private HashSet<Policy> children;

    public BooleanPolicy(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    public BooleanPolicy(BooleanOperator operator, Collection<? extends Policy> children) {
        this.operator = operator;
        this.children = new HashSet();
        this.children.addAll(children);
    }

    public BooleanPolicy(BooleanOperator operator, Policy ... children) {
        this(operator, Arrays.asList(children));
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    @Override
    public boolean isFulfilled(Collection<? extends PolicyFact> facts) throws WrongAccessStructureException {
        int fulfilled = 0;
        for (Policy policy : this.children) {
            fulfilled += policy.isFulfilled(facts) ? 1 : 0;
        }
        if (this.operator == BooleanOperator.AND) {
            return fulfilled >= this.children.size();
        }
        return fulfilled >= 1;
    }

    public BooleanOperator getOperator() {
        return this.operator;
    }

    public Set<Policy> getChildren() {
        return new HashSet<Policy>(this.children);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + this.operator.ordinal();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BooleanPolicy other = (BooleanPolicy)obj;
        if (this.children == null) {
            if (other.children != null) {
                return false;
            }
        } else {
            if (!this.children.containsAll(other.children)) {
                return false;
            }
            if (!other.children.containsAll(this.children)) {
                return false;
            }
        }
        return this.operator == other.operator;
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        return AnnotatedUbrUtil.autoAccumulate((ByteAccumulator)accumulator, (Object)this);
    }

    public static enum BooleanOperator {
        AND,
        OR;

    }
}

