/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.enc.asym.elgamal;

import java.util.Objects;
import org.cryptimeleon.craco.enc.DecryptionKey;
import org.cryptimeleon.craco.enc.asym.elgamal.ElgamalEncryption;
import org.cryptimeleon.craco.enc.asym.elgamal.ElgamalPublicKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class ElgamalPrivateKey
implements DecryptionKey {
    @Represented(restorer="Zn")
    private Zn.ZnElement a;
    @Represented(restorer="Scheme")
    private ElgamalPublicKey publicKey;

    public ElgamalPrivateKey(Representation repr, ElgamalEncryption scheme) {
        new ReprUtil((Object)this).register((RepresentationRestorer)scheme.getGroup().getZn(), "Zn").register((RepresentationRestorer)scheme, "Scheme").deserialize(repr);
    }

    private void init(Group groupG, GroupElement g, Zn.ZnElement a, GroupElement h) {
        this.a = a;
        this.publicKey = new ElgamalPublicKey(g, h);
    }

    public ElgamalPrivateKey(ElgamalPublicKey pub, Zn.ZnElement a) {
        this.a = a;
        this.publicKey = pub;
    }

    private void init(Group groupG, GroupElement g, Zn.ZnElement a) {
        this.init(groupG, g, a, g.pow(a));
    }

    private void init(Group groupG, GroupElement g) {
        Zn z = new Zn(groupG.size());
        Zn.ZnElement a = z.getUniformlyRandomElement();
        this.init(groupG, g, a);
    }

    private void init(Group groupG) {
        GroupElement g = groupG.getGenerator();
        this.init(groupG, g);
    }

    public ElgamalPrivateKey(Group groupG, GroupElement g, Zn.ZnElement a, GroupElement h) {
        this.init(groupG, g, a, h);
    }

    public ElgamalPrivateKey(Group groupG, GroupElement g, Zn.ZnElement a) {
        this.init(groupG, g, a);
    }

    public ElgamalPrivateKey(Group groupG, GroupElement g) {
        this.init(groupG, g);
    }

    public ElgamalPrivateKey(Group groupG) {
        this.init(groupG);
    }

    public ElgamalPublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(ElgamalPublicKey pk) {
        this.publicKey = pk;
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public Zn.ZnElement getA() {
        return this.a;
    }

    public Group getGroupG() {
        return this.publicKey.getG().getStructure();
    }

    public GroupElement getG() {
        return this.publicKey.getG();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.a == null ? 0 : this.a.hashCode());
        result = 31 * result + (this.publicKey == null ? 0 : this.publicKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElgamalPrivateKey other = (ElgamalPrivateKey)obj;
        return Objects.equals(this.a, other.a) && Objects.equals(this.publicKey, other.publicKey);
    }
}

