/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.enc.sym.streaming.aes;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.cryptimeleon.craco.common.ByteArrayImplementation;
import org.cryptimeleon.craco.enc.sym.streaming.aes.AbstractStreamingSymmetricScheme;
import org.cryptimeleon.math.serialization.Representation;

public class StreamingGCMAES
extends AbstractStreamingSymmetricScheme {
    private static final int initialVectorLength = 96;
    private static final int tagLength = 128;
    private static final String transformation = "AES/GCM/NoPadding";

    public StreamingGCMAES() {
        super(transformation, 96);
    }

    public StreamingGCMAES(int keyLength) {
        super(transformation, 96, keyLength);
    }

    public StreamingGCMAES(Representation repr) {
        this(repr.bigInt().getInt());
    }

    @Override
    public void initCipher(Cipher cipher, ByteArrayImplementation symmetricKey, int mode) throws InvalidAlgorithmParameterException, InvalidKeyException {
        SecretKeySpec keySpec = new SecretKeySpec(symmetricKey.getData(), "AES");
        GCMParameterSpec gcmSpec = new GCMParameterSpec(128, this.initialVector);
        cipher.init(mode, (Key)keySpec, gcmSpec);
    }
}

