/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.kem;

import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.enc.CipherText;
import org.cryptimeleon.craco.enc.DecryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKey;
import org.cryptimeleon.craco.enc.EncryptionScheme;
import org.cryptimeleon.craco.enc.SymmetricKey;
import org.cryptimeleon.craco.kem.KeyDerivationFunction;
import org.cryptimeleon.craco.kem.KeyEncapsulationMechanism;
import org.cryptimeleon.craco.kem.UniqueByteKeyMaterial;
import org.cryptimeleon.math.serialization.Representation;

public abstract class AbstractHybridConstructionKEM
implements KeyEncapsulationMechanism<SymmetricKey> {
    protected EncryptionScheme scheme;
    protected KeyDerivationFunction<? extends SymmetricKey> kdf;

    public AbstractHybridConstructionKEM(EncryptionScheme scheme, KeyDerivationFunction<? extends SymmetricKey> kdf) {
        this.scheme = scheme;
        this.kdf = kdf;
    }

    protected abstract PlainText generateRandomPlaintext();

    protected abstract int getPlaintextMinEntropyInBit();

    @Override
    public KeyEncapsulationMechanism.KeyAndCiphertext<SymmetricKey> encaps(EncryptionKey pk) {
        KeyEncapsulationMechanism.KeyAndCiphertext<SymmetricKey> result = new KeyEncapsulationMechanism.KeyAndCiphertext<SymmetricKey>();
        PlainText pt = this.generateRandomPlaintext();
        CipherText encryptedPt = this.scheme.encrypt(pt, pk);
        UniqueByteKeyMaterial material = new UniqueByteKeyMaterial(pt, this.getPlaintextMinEntropyInBit());
        SymmetricKey key = this.kdf.deriveKey(material);
        result.encapsulatedKey = encryptedPt;
        result.key = key;
        return result;
    }

    @Override
    public SymmetricKey decaps(CipherText encapsulatedKey, DecryptionKey sk) {
        PlainText pt = this.scheme.decrypt(encapsulatedKey, sk);
        UniqueByteKeyMaterial material = new UniqueByteKeyMaterial(pt, this.getPlaintextMinEntropyInBit());
        return this.kdf.deriveKey(material);
    }

    @Override
    public CipherText restoreEncapsulatedKey(Representation repr) {
        return this.scheme.restoreCipherText(repr);
    }

    @Override
    public EncryptionKey restoreEncapsulationKey(Representation repr) {
        return this.scheme.restoreEncryptionKey(repr);
    }

    @Override
    public DecryptionKey restoreDecapsulationKey(Representation repr) {
        return this.scheme.restoreDecryptionKey(repr);
    }
}

