/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.kem;

import java.util.Objects;
import org.cryptimeleon.craco.enc.CipherText;
import org.cryptimeleon.craco.enc.DecryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKey;
import org.cryptimeleon.craco.enc.SymmetricKey;
import org.cryptimeleon.craco.kem.KeyDerivationFunction;
import org.cryptimeleon.craco.kem.KeyEncapsulationMechanism;
import org.cryptimeleon.craco.kem.KeyMaterial;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;

public abstract class SymmetricKeyKEM
implements KeyEncapsulationMechanism<SymmetricKey> {
    @Represented
    protected KeyEncapsulationMechanism<? extends KeyMaterial> kem;
    @Represented
    protected KeyDerivationFunction<? extends SymmetricKey> kdf;

    public SymmetricKeyKEM(KeyEncapsulationMechanism<? extends KeyMaterial> kem, KeyDerivationFunction<? extends SymmetricKey> kdf) {
        this.kem = kem;
        this.kdf = kdf;
    }

    public SymmetricKeyKEM(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    @Override
    public KeyEncapsulationMechanism.KeyAndCiphertext<SymmetricKey> encaps(EncryptionKey pk) {
        KeyEncapsulationMechanism.KeyAndCiphertext<SymmetricKey> output = new KeyEncapsulationMechanism.KeyAndCiphertext<SymmetricKey>();
        KeyEncapsulationMechanism.KeyAndCiphertext<? extends KeyMaterial> temp = this.kem.encaps(pk);
        output.key = this.kdf.deriveKey((KeyMaterial)temp.key);
        output.encapsulatedKey = temp.encapsulatedKey;
        return output;
    }

    @Override
    public SymmetricKey decaps(CipherText encapsulatedKey, DecryptionKey sk) {
        return this.kdf.deriveKey(this.kem.decaps(encapsulatedKey, sk));
    }

    @Override
    public CipherText restoreEncapsulatedKey(Representation repr) {
        return this.kem.restoreEncapsulatedKey(repr);
    }

    @Override
    public EncryptionKey restoreEncapsulationKey(Representation repr) {
        return this.kem.restoreEncapsulationKey(repr);
    }

    @Override
    public DecryptionKey restoreDecapsulationKey(Representation repr) {
        return this.kem.restoreDecapsulationKey(repr);
    }

    public KeyEncapsulationMechanism<? extends KeyMaterial> getKem() {
        return this.kem;
    }

    public KeyDerivationFunction<? extends SymmetricKey> getKdf() {
        return this.kdf;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymmetricKeyKEM other = (SymmetricKeyKEM)o;
        return Objects.equals(this.kem, other.kem) && Objects.equals(this.kdf, other.kdf);
    }

    public int hashCode() {
        int result = this.kem != null ? this.kem.hashCode() : 0;
        result = 31 * result + (this.kdf != null ? this.kdf.hashCode() : 0);
        return result;
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }
}

