/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.kem;

import java.util.Objects;
import org.cryptimeleon.craco.kem.KeyMaterial;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;

public class UniqueByteKeyMaterial
implements KeyMaterial {
    private final UniqueByteRepresentable e;
    private final int minEntropy;

    public UniqueByteKeyMaterial(UniqueByteRepresentable e, int minEntropyOfSource) {
        this.e = e;
        this.minEntropy = minEntropyOfSource;
    }

    public UniqueByteRepresentable getElement() {
        return this.e;
    }

    @Override
    public int getMinEntropyInBit() {
        return this.minEntropy;
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        accumulator = this.e.updateAccumulator(accumulator);
        return accumulator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniqueByteKeyMaterial other = (UniqueByteKeyMaterial)o;
        return this.minEntropy == other.minEntropy && Objects.equals(this.e, other.e);
    }

    public int hashCode() {
        int result = this.e.hashCode();
        result = 31 * result + this.minEntropy;
        return result;
    }
}

