/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.kem.asym.elgamal;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.craco.common.ByteArrayImplementation;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.enc.CipherText;
import org.cryptimeleon.craco.enc.DecryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKeyPair;
import org.cryptimeleon.craco.enc.SymmetricKey;
import org.cryptimeleon.craco.enc.asym.elgamal.ElgamalCipherText;
import org.cryptimeleon.craco.enc.asym.elgamal.ElgamalEncryption;
import org.cryptimeleon.craco.enc.asym.elgamal.ElgamalPrivateKey;
import org.cryptimeleon.craco.kem.KeyEncapsulationMechanism;
import org.cryptimeleon.craco.kem.asym.AsymmetricKEM;
import org.cryptimeleon.craco.kem.asym.elgamal.ElgamalKEMCiphertext;
import org.cryptimeleon.math.hash.HashFunction;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.hash.impl.ByteArrayAccumulator;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;

public class ElgamalKEM
implements AsymmetricKEM<SymmetricKey> {
    @Represented
    private ElgamalEncryption encryptionScheme;
    @Represented
    private HashFunction messageDigest;

    public ElgamalKEM(Group group, HashFunction md) {
        this.encryptionScheme = new ElgamalEncryption(group);
        this.messageDigest = md;
    }

    public ElgamalKEM(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.encryptionScheme == null ? 0 : this.encryptionScheme.hashCode());
        result = 31 * result + (this.messageDigest == null ? 0 : this.messageDigest.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElgamalKEM other = (ElgamalKEM)obj;
        return Objects.equals(this.encryptionScheme, other.encryptionScheme) && Objects.equals(this.messageDigest, other.messageDigest);
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    @Override
    public KeyEncapsulationMechanism.KeyAndCiphertext<SymmetricKey> encaps(EncryptionKey pk) {
        KeyAndCiphertextAndNonce kcn = this.encaps_internal(pk);
        return kcn.keyAndCiphertext;
    }

    public KeyAndCiphertextAndNonce encaps_internal(EncryptionKey pk) {
        HashFunction md = this.messageDigest;
        byte[] random = RandomGenerator.getRandomBytes((int)md.getOutputLength());
        GroupElement R = this.encryptionScheme.getGroup().getUniformlyRandomElement();
        GroupElementPlainText M = new GroupElementPlainText(R);
        ByteArrayImplementation r = new ByteArrayImplementation(md.hash((UniqueByteRepresentable)R));
        ByteArrayImplementation k = new ByteArrayImplementation(random);
        byte[] h = this.computeNonceHash(md, R, k);
        BigInteger s = new BigInteger(h);
        ElgamalCipherText c = (ElgamalCipherText)this.encryptionScheme.encrypt(M, pk, s);
        ByteArrayImplementation encaps = k.xor(r);
        ElgamalKEMCiphertext C = new ElgamalKEMCiphertext(c, encaps);
        KeyEncapsulationMechanism.KeyAndCiphertext<SymmetricKey> result = new KeyEncapsulationMechanism.KeyAndCiphertext<SymmetricKey>();
        result.encapsulatedKey = C;
        result.key = k;
        return new KeyAndCiphertextAndNonce(result, s);
    }

    private byte[] computeNonceHash(HashFunction md, GroupElement r, ByteArrayImplementation k) {
        ByteArrayAccumulator acu = new ByteArrayAccumulator();
        acu.append((UniqueByteRepresentable)r);
        acu.append((UniqueByteRepresentable)k);
        byte[] hash = md.hash(acu.extractBytes());
        ByteArrayAccumulator hAccu = new ByteArrayAccumulator();
        hAccu.append(new byte[]{0});
        hAccu.append(hash);
        return hAccu.extractBytes();
    }

    @Override
    public ByteArrayImplementation decaps(CipherText encapsulatedKey, DecryptionKey sk) {
        HashFunction md = this.messageDigest;
        ElgamalKEMCiphertext C = (ElgamalKEMCiphertext)encapsulatedKey;
        GroupElementPlainText M = (GroupElementPlainText)this.encryptionScheme.decrypt(C.getElgamalCipherText(), sk);
        GroupElement R = M.get();
        ByteArrayImplementation r = new ByteArrayImplementation(md.hash((UniqueByteRepresentable)R));
        ByteArrayImplementation k = C.getSymmetricEncryption().xor(r);
        byte[] h = this.computeNonceHash(md, R, k);
        BigInteger s = new BigInteger(h);
        ElgamalCipherText c_prime = (ElgamalCipherText)this.encryptionScheme.encrypt(M, ((ElgamalPrivateKey)sk).getPublicKey(), s);
        if (c_prime.getC2().equals(C.getElgamalCipherText().getC2())) {
            return k;
        }
        return new ByteArrayImplementation(new byte[0]);
    }

    @Override
    public EncryptionKeyPair generateKeyPair() {
        return this.encryptionScheme.generateKeyPair();
    }

    public ByteArrayImplementation getKey(Representation repr) {
        return new ByteArrayImplementation(repr);
    }

    @Override
    public ElgamalKEMCiphertext restoreEncapsulatedKey(Representation repr) {
        return new ElgamalKEMCiphertext(repr, this.encryptionScheme);
    }

    @Override
    public EncryptionKey restoreEncapsulationKey(Representation repr) {
        return this.encryptionScheme.restoreEncryptionKey(repr);
    }

    @Override
    public ElgamalPrivateKey restoreDecapsulationKey(Representation repr) {
        return this.encryptionScheme.restoreDecryptionKey(repr);
    }

    public ElgamalEncryption getEncryptionScheme() {
        return this.encryptionScheme;
    }

    public void setEncryptionScheme(ElgamalEncryption encryptionScheme) {
        this.encryptionScheme = encryptionScheme;
    }

    public HashFunction getHashFunction() {
        return this.messageDigest;
    }

    public void setHashFunction(HashFunction messageDigest) {
        this.messageDigest = messageDigest;
    }

    public class KeyAndCiphertextAndNonce {
        public KeyEncapsulationMechanism.KeyAndCiphertext<SymmetricKey> keyAndCiphertext;
        public BigInteger nonce;

        public KeyAndCiphertextAndNonce(KeyEncapsulationMechanism.KeyAndCiphertext<SymmetricKey> keyAndCiphertext, BigInteger nonce) {
            this.keyAndCiphertext = keyAndCiphertext;
            this.nonce = nonce;
        }
    }
}

