/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments;

import org.cryptimeleon.craco.protocols.CommonInput;
import org.cryptimeleon.craco.protocols.SecretInput;
import org.cryptimeleon.craco.protocols.TwoPartyProtocol;
import org.cryptimeleon.craco.protocols.arguments.InteractiveArgumentInstance;

public interface InteractiveArgument
extends TwoPartyProtocol {
    public static final String PROVER_ROLE = "prover";
    public static final String VERIFIER_ROLE = "verifier";

    @Override
    default public String[] getRoleNames() {
        return new String[]{PROVER_ROLE, VERIFIER_ROLE};
    }

    @Override
    public InteractiveArgumentInstance instantiateProtocol(String var1, CommonInput var2, SecretInput var3);

    default public InteractiveArgumentInstance instantiateProver(CommonInput commonInput, SecretInput witness) {
        return this.instantiateProtocol(PROVER_ROLE, commonInput, witness);
    }

    default public InteractiveArgumentInstance instantiateVerifier(CommonInput commonInput) {
        return this.instantiateProtocol(VERIFIER_ROLE, commonInput, null);
    }

    default public void debugProof(CommonInput commonInput, SecretInput secretInput) {
        InteractiveArgumentInstance prover = this.instantiateProver(commonInput, secretInput);
        InteractiveArgumentInstance verifier = this.instantiateVerifier(commonInput);
        this.runProtocolLocally(prover, verifier);
        if (!verifier.isAccepting()) {
            throw new RuntimeException(this.getClass().getName() + " proof fails, but cause is unclear.");
        }
    }
}

