/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma;

import org.cryptimeleon.craco.protocols.CommonInput;
import org.cryptimeleon.craco.protocols.arguments.sigma.Announcement;
import org.cryptimeleon.craco.protocols.arguments.sigma.Challenge;
import org.cryptimeleon.craco.protocols.arguments.sigma.Response;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocol;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.Representation;

public class SigmaProtocolTranscript
implements Representable {
    protected Announcement announcement;
    protected Challenge challenge;
    protected Response response;

    public SigmaProtocolTranscript(Announcement announcement, Challenge challenge, Response response) {
        this.announcement = announcement;
        this.challenge = challenge;
        this.response = response;
    }

    public SigmaProtocolTranscript(SigmaProtocol protocol, CommonInput commonInput, Representation repr) {
        this.announcement = protocol.restoreAnnouncement(commonInput, repr.obj().get("a"));
        this.challenge = protocol.restoreChallenge(commonInput, repr.obj().get("c"));
        this.response = protocol.restoreResponse(commonInput, this.announcement, this.challenge, repr.obj().get("r"));
    }

    public Announcement getAnnouncement() {
        return this.announcement;
    }

    public Challenge getChallenge() {
        return this.challenge;
    }

    public Response getResponse() {
        return this.response;
    }

    public Representation getRepresentation() {
        ObjectRepresentation repr = new ObjectRepresentation();
        repr.put("a", this.announcement.getRepresentation());
        repr.put("c", this.challenge.getRepresentation());
        repr.put("r", this.response.getRepresentation());
        return repr;
    }
}

