/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma.schnorr;

import org.cryptimeleon.craco.protocols.arguments.sigma.Announcement;
import org.cryptimeleon.craco.protocols.arguments.sigma.AnnouncementSecret;
import org.cryptimeleon.craco.protocols.arguments.sigma.Response;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocolTranscript;
import org.cryptimeleon.craco.protocols.arguments.sigma.ZnChallenge;
import org.cryptimeleon.craco.protocols.arguments.sigma.ZnChallengeSpace;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.SchnorrFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariable;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariableAssignment;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.VariableExpression;
import org.cryptimeleon.math.expressions.bool.BooleanExpression;
import org.cryptimeleon.math.expressions.bool.ExponentEqualityExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentSumExpr;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class LinearExponentStatementFragment
implements SchnorrFragment {
    private ExponentExpr homomorphicPart;
    private Zn.ZnElement target;
    private Zn zn;

    public LinearExponentStatementFragment(ExponentExpr homomorphicPart, Zn.ZnElement target) {
        this.init(homomorphicPart, target);
    }

    public LinearExponentStatementFragment(ExponentEqualityExpr equation, Zn zn) throws IllegalArgumentException {
        ExponentSumExpr linearized = equation.getLhs().sub(equation.getRhs()).linearize();
        this.init(linearized.getRhs(), linearized.getLhs().negate().evaluate(zn));
    }

    private void init(ExponentExpr homomorphicPart, Zn.ZnElement target) {
        this.homomorphicPart = homomorphicPart;
        this.target = target;
        this.zn = target.getStructure();
        homomorphicPart.treeWalk(expr -> {
            if (expr instanceof VariableExpression && !(expr instanceof SchnorrVariable)) {
                throw new IllegalArgumentException("Expressions must not contain non-Schnorr variables like " + expr.getClass() + " - " + expr.toString());
            }
        });
    }

    @Override
    public AnnouncementSecret generateAnnouncementSecret(SchnorrVariableAssignment externalWitnesses) {
        return AnnouncementSecret.EMPTY;
    }

    @Override
    public Announcement generateAnnouncement(SchnorrVariableAssignment externalWitnesses, AnnouncementSecret announcementSecret, SchnorrVariableAssignment externalRandom) {
        return new LinearExponentStatementAnnouncement(this.homomorphicPart.evaluate(this.zn, (Substitution)externalRandom));
    }

    @Override
    public Response generateResponse(SchnorrVariableAssignment externalWitnesses, AnnouncementSecret announcementSecret, ZnChallenge challenge) {
        return Response.EMPTY;
    }

    @Override
    public BooleanExpression checkTranscript(Announcement announcement, ZnChallenge challenge, Response response, SchnorrVariableAssignment externalResponse) {
        Zn.ZnElement evaluatedResponse = this.homomorphicPart.evaluate(this.zn, (Substitution)externalResponse);
        return BooleanExpression.valueOf((boolean)evaluatedResponse.equals((Object)((LinearExponentStatementAnnouncement)announcement).announcement.add((Element)this.target.mul(challenge.getChallenge()))));
    }

    @Override
    public SigmaProtocolTranscript generateSimulatedTranscript(ZnChallenge challenge, SchnorrVariableAssignment externalRandomResponse) {
        Zn.ZnElement announcement = this.homomorphicPart.evaluate(this.zn, (Substitution)externalRandomResponse).sub((Element)this.target.mul(challenge.getChallenge()));
        return new SigmaProtocolTranscript(new LinearExponentStatementAnnouncement(announcement), challenge, Response.EMPTY);
    }

    @Override
    public Announcement restoreAnnouncement(Representation repr) {
        return new LinearExponentStatementAnnouncement(this.zn.restoreElement(repr));
    }

    @Override
    public Response restoreResponse(Announcement announcement, Representation repr) {
        return Response.EMPTY;
    }

    @Override
    public Representation compressTranscript(Announcement announcement, ZnChallenge challenge, Response response, SchnorrVariableAssignment externalResponse) {
        return response.getRepresentation();
    }

    @Override
    public SigmaProtocolTranscript decompressTranscript(Representation compressedTranscript, ZnChallenge challenge, SchnorrVariableAssignment externalResponse) throws IllegalArgumentException {
        return this.generateSimulatedTranscript(challenge, externalResponse);
    }

    @Override
    public void debugFragment(SchnorrVariableAssignment externalWitness, ZnChallengeSpace challengeSpace) {
        Zn.ZnElement result = this.homomorphicPart.evaluate(this.zn, (Substitution)externalWitness);
        if (!result.equals((Object)this.target)) {
            throw new RuntimeException(result + " != " + this.target);
        }
    }

    public static final class LinearExponentStatementAnnouncement
    implements Announcement {
        public final Zn.ZnElement announcement;

        public LinearExponentStatementAnnouncement(Zn.ZnElement announcement) {
            this.announcement = announcement;
        }

        public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
            accumulator.append((UniqueByteRepresentable)this.announcement);
            return accumulator;
        }

        public Representation getRepresentation() {
            return this.announcement.getRepresentation();
        }
    }
}

