/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma.schnorr;

import org.cryptimeleon.craco.protocols.arguments.sigma.Announcement;
import org.cryptimeleon.craco.protocols.arguments.sigma.AnnouncementSecret;
import org.cryptimeleon.craco.protocols.arguments.sigma.Response;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocolTranscript;
import org.cryptimeleon.craco.protocols.arguments.sigma.ZnChallenge;
import org.cryptimeleon.craco.protocols.arguments.sigma.ZnChallengeSpace;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.SchnorrFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariable;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariableAssignment;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.VariableExpression;
import org.cryptimeleon.math.expressions.bool.BooleanExpression;
import org.cryptimeleon.math.expressions.bool.GroupEqualityExpr;
import org.cryptimeleon.math.expressions.group.GroupElementExpression;
import org.cryptimeleon.math.expressions.group.GroupOpExpr;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.groups.GroupElement;

public class LinearStatementFragment
implements SchnorrFragment {
    private GroupElementExpression homomorphicPart;
    private GroupElement target;

    public LinearStatementFragment(GroupElementExpression homomorphicPart, GroupElement target) {
        this.init(homomorphicPart, target);
    }

    public LinearStatementFragment(GroupEqualityExpr equation) throws IllegalArgumentException {
        GroupOpExpr linearized = equation.getLhs().op(equation.getRhs().inv()).linearize();
        this.init(linearized.getRhs(), linearized.getLhs().inv().evaluate());
    }

    private void init(GroupElementExpression homomorphicPart, GroupElement target) {
        this.homomorphicPart = homomorphicPart;
        this.target = target;
        homomorphicPart.treeWalk(expr -> {
            if (expr instanceof VariableExpression && !(expr instanceof SchnorrVariable)) {
                throw new IllegalArgumentException("Expressions must not contain non-Schnorr variables like " + expr.getClass() + " - " + expr.toString());
            }
        });
    }

    @Override
    public AnnouncementSecret generateAnnouncementSecret(SchnorrVariableAssignment externalWitnesses) {
        return AnnouncementSecret.EMPTY;
    }

    @Override
    public Announcement generateAnnouncement(SchnorrVariableAssignment externalWitnesses, AnnouncementSecret announcementSecret, SchnorrVariableAssignment externalRandom) {
        return new LinearStatementAnnouncement(this.homomorphicPart.evaluate((Substitution)externalRandom).compute());
    }

    @Override
    public Response generateResponse(SchnorrVariableAssignment externalWitnesses, AnnouncementSecret announcementSecret, ZnChallenge challenge) {
        return Response.EMPTY;
    }

    @Override
    public BooleanExpression checkTranscript(Announcement announcement, ZnChallenge challenge, Response response, SchnorrVariableAssignment externalResponse) {
        return this.homomorphicPart.substitute((Substitution)externalResponse).isEqualTo(((LinearStatementAnnouncement)announcement).announcement.op((Element)this.target.pow(challenge.getChallenge())));
    }

    @Override
    public SigmaProtocolTranscript generateSimulatedTranscript(ZnChallenge challenge, SchnorrVariableAssignment externalRandomResponse) {
        GroupElement announcement = this.homomorphicPart.evaluate((Substitution)externalRandomResponse).op((Element)this.target.pow(challenge.getChallenge().negate())).compute();
        return new SigmaProtocolTranscript(new LinearStatementAnnouncement(announcement), challenge, Response.EMPTY);
    }

    @Override
    public Announcement restoreAnnouncement(Representation repr) {
        return new LinearStatementAnnouncement(this.target.getStructure().restoreElement(repr));
    }

    @Override
    public Response restoreResponse(Announcement announcement, Representation repr) {
        return Response.EMPTY;
    }

    @Override
    public Representation compressTranscript(Announcement announcement, ZnChallenge challenge, Response response, SchnorrVariableAssignment externalResponse) {
        return response.getRepresentation();
    }

    @Override
    public SigmaProtocolTranscript decompressTranscript(Representation compressedTranscript, ZnChallenge challenge, SchnorrVariableAssignment externalResponse) throws IllegalArgumentException {
        return this.generateSimulatedTranscript(challenge, externalResponse);
    }

    @Override
    public void debugFragment(SchnorrVariableAssignment externalWitness, ZnChallengeSpace challengeSpace) {
        GroupElement result = this.homomorphicPart.evaluate((Substitution)externalWitness);
        if (!result.equals(this.target)) {
            throw new RuntimeException(result + " != " + this.target);
        }
    }

    public static final class LinearStatementAnnouncement
    implements Announcement {
        public final GroupElement announcement;

        public LinearStatementAnnouncement(GroupElement announcement) {
            this.announcement = announcement;
        }

        public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
            accumulator.append((UniqueByteRepresentable)this.announcement);
            return accumulator;
        }

        public Representation getRepresentation() {
            return this.announcement.getRepresentation();
        }
    }
}

