/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.setmembership;

import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.LinearStatementFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.SendFirstValue;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.SendThenDelegateFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.setmembership.SetMembershipPublicParameters;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariableAssignment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrZnVariable;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.bool.BooleanExpression;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.Structure;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class SetMembershipFragment
extends SendThenDelegateFragment {
    private final SetMembershipPublicParameters pp;
    private final ExponentExpr member;

    public SetMembershipFragment(SetMembershipPublicParameters pp, ExponentExpr member) {
        this.pp = pp;
        this.member = member;
    }

    @Override
    protected SendThenDelegateFragment.ProverSpec provideProverSpec(SchnorrVariableAssignment externalWitnesses, SendThenDelegateFragment.ProverSpecBuilder builder) {
        Zn.ZnElement r = this.pp.getZn().getUniformlyRandomNonzeroElement();
        builder.putWitnessValue("r", r);
        Zn.ZnElement memberVal = this.member.evaluate(this.pp.getZn(), (Substitution)externalWitnesses);
        if (!this.pp.signatures.containsKey(memberVal.getInteger())) {
            throw new IllegalArgumentException("Proposed member value " + memberVal.getInteger() + " is not actually in the set. Illegal witness.");
        }
        GroupElement signature = this.pp.signatures.get(memberVal.getInteger());
        GroupElement blindedSignature = signature.pow(r);
        builder.setSendFirstValue(new SendFirstValue.AlgebraicSendFirstValue(new Element[]{blindedSignature}));
        return builder.build();
    }

    @Override
    protected SendFirstValue restoreSendFirstValue(Representation repr) {
        return new SendFirstValue.AlgebraicSendFirstValue(repr, new Structure[]{this.pp.bilinearGroup.getG1()});
    }

    @Override
    protected SendFirstValue simulateSendFirstValue() {
        return new SendFirstValue.AlgebraicSendFirstValue(new Element[]{this.pp.bilinearGroup.getG1().getUniformlyRandomNonNeutral()});
    }

    @Override
    protected SendThenDelegateFragment.SubprotocolSpec provideSubprotocolSpec(SendFirstValue sendFirstValue, SendThenDelegateFragment.SubprotocolSpecBuilder builder) {
        GroupElement blindedSignature = ((SendFirstValue.AlgebraicSendFirstValue)sendFirstValue).getGroupElement(0);
        SchnorrZnVariable signatureBlindingValue = builder.addZnVariable("r", this.pp.getZn());
        builder.addSubprotocol("signatureCheck", new LinearStatementFragment(this.pp.bilinearGroup.getBilinearMap().applyExpr(blindedSignature, this.pp.pk.op(this.pp.g2.pow(this.member))).isEqualTo(this.pp.egg.pow((ExponentExpr)signatureBlindingValue))));
        return builder.build();
    }

    @Override
    protected BooleanExpression provideAdditionalCheck(SendFirstValue sendFirstValue) {
        return BooleanExpression.valueOf((!((SendFirstValue.AlgebraicSendFirstValue)sendFirstValue).getGroupElement(0).isNeutralElement() ? 1 : 0) != 0);
    }
}

