/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.setmembership;

import java.math.BigInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.DelegateFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.SendThenDelegateFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.setmembership.SetMembershipPublicParameters;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.setmembership.SmallerThanPowerFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariableAssignment;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class TwoSidedRangeProof
extends DelegateFragment {
    private final ExponentExpr member;
    private final Zn.ZnElement lowerBound;
    private final Zn.ZnElement upperBound;
    private final SetMembershipPublicParameters pp;
    private final int base;
    private final int power;

    public TwoSidedRangeProof(ExponentExpr member, Zn.ZnElement lowerBound, Zn.ZnElement upperBound, SetMembershipPublicParameters pp) {
        this.member = member;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.pp = pp;
        this.base = pp.signatures.size();
        BigInteger intervalSize = upperBound.getInteger().subtract(lowerBound.getInteger());
        if (intervalSize.signum() < 0) {
            throw new IllegalArgumentException("upper bound must be larger than lower bound");
        }
        int power = intervalSize.bitLength();
        while (BigInteger.valueOf(this.base).pow(power).compareTo(intervalSize) <= 0) {
            ++power;
        }
        this.power = power;
        if (lowerBound.getInteger().add(BigInteger.valueOf(this.base).pow(power)).compareTo(pp.getZn().size()) > 0) {
            throw new IllegalArgumentException("Interval is too close to the mod p overflow boundary (i.e. numbers in the interval are too large - choose smaller numbers)");
        }
    }

    public TwoSidedRangeProof(ExponentExpr member, int lowerBound, int upperBound, SetMembershipPublicParameters pp) {
        this(member, BigInteger.valueOf(lowerBound), BigInteger.valueOf(upperBound), pp);
    }

    public TwoSidedRangeProof(ExponentExpr member, BigInteger lowerBound, BigInteger upperBound, SetMembershipPublicParameters pp) {
        this(member, pp.getZn().valueOf(lowerBound), pp.getZn().valueOf(upperBound), pp);
    }

    @Override
    protected SendThenDelegateFragment.ProverSpec provideProverSpecWithNoSendFirst(SchnorrVariableAssignment externalWitnesses, SendThenDelegateFragment.ProverSpecBuilder builder) {
        return builder.build();
    }

    @Override
    protected SendThenDelegateFragment.SubprotocolSpec provideSubprotocolSpec(SendThenDelegateFragment.SubprotocolSpecBuilder builder) {
        builder.addSubprotocol("member-lowerBound >= 0", new SmallerThanPowerFragment(this.member.sub(this.lowerBound), this.base, this.power, this.pp));
        builder.addSubprotocol("upperBound-member >= 0", new SmallerThanPowerFragment(this.upperBound.asExponentExpression().sub(this.member), this.base, this.power, this.pp));
        return builder.build();
    }

    public static SetMembershipPublicParameters generatePublicParameters(BilinearGroup group, int base) {
        return SetMembershipPublicParameters.generate(group, IntStream.range(0, base).mapToObj(BigInteger::valueOf).collect(Collectors.toSet()));
    }
}

