/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.secretsharing;

import java.util.List;
import java.util.Objects;
import org.cryptimeleon.craco.common.policies.Policy;
import org.cryptimeleon.craco.common.policies.ThresholdPolicy;
import org.cryptimeleon.craco.secretsharing.LinearSecretSharing;
import org.cryptimeleon.craco.secretsharing.SecretSharingTreeNode;

public class InnerSecretSharingNode
implements SecretSharingTreeNode {
    private List<SecretSharingTreeNode> children;
    private int numberOfShares;
    private ThresholdPolicy policy;
    private LinearSecretSharing<Policy> lsss;

    public InnerSecretSharingNode(List<SecretSharingTreeNode> children, int numberOfShares, ThresholdPolicy policy, LinearSecretSharing<Policy> lsss) {
        this.children = children;
        this.numberOfShares = numberOfShares;
        this.policy = policy;
        this.lsss = lsss;
    }

    @Override
    public int getNumberOfChildren() {
        return this.children.size();
    }

    @Override
    public int getNumberOfShares() {
        return this.numberOfShares;
    }

    @Override
    public ThresholdPolicy getPolicy() {
        return this.policy;
    }

    public List<SecretSharingTreeNode> getChildren() {
        return this.children;
    }

    public LinearSecretSharing<Policy> getLsss() {
        return this.lsss;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InnerSecretSharingNode that = (InnerSecretSharingNode)o;
        return this.numberOfShares == that.numberOfShares && Objects.equals(this.children, that.children) && Objects.equals(this.policy, that.policy) && Objects.equals(this.lsss, that.lsss);
    }

    public int hashCode() {
        return Objects.hash(this.children, this.numberOfShares, this.policy, this.lsss);
    }
}

