/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.secretsharing;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cryptimeleon.craco.secretsharing.accessstructure.exceptions.NoSatisfyingSet;
import org.cryptimeleon.craco.secretsharing.accessstructure.exceptions.WrongAccessStructureException;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public interface LinearSecretSharing<ShareReceiverType> {
    public Map<Integer, Zp.ZpElement> getShares(Zp.ZpElement var1) throws WrongAccessStructureException;

    public Map<Integer, Zp.ZpElement> getSolvingVector(Set<? extends ShareReceiverType> var1) throws NoSatisfyingSet, WrongAccessStructureException;

    default public Zp.ZpElement reconstruct(Map<Integer, Zp.ZpElement> shares) throws NoSatisfyingSet, WrongAccessStructureException {
        Set shareReceivers = this.getShareReceiverMap().entrySet().stream().filter(entry -> shares.containsKey(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
        Map<Integer, Zp.ZpElement> solvingVector = this.getSolvingVector(shareReceivers);
        return shares.entrySet().stream().map(e -> ((Zp.ZpElement)e.getValue()).mul((Element)solvingVector.getOrDefault(e.getKey(), this.getSharedRing().getZeroElement()))).reduce(this.getSharedRing().getZeroElement(), Zp.ZpElement::add);
    }

    default public ShareReceiverType getShareReceiver(Integer i) {
        return this.getShareReceiverMap().get(i);
    }

    public Map<Integer, ShareReceiverType> getShareReceiverMap();

    default public Set<Integer> getSharesOfReceiver(ShareReceiverType shareReceiver) {
        return this.getSharesOfReceivers(Collections.singletonList(shareReceiver));
    }

    default public Set<Integer> getSharesOfReceivers(Collection<? extends ShareReceiverType> shareReceivers) {
        return this.getShareReceiverMap().entrySet().stream().filter(e -> shareReceivers.contains(e.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public boolean isQualified(Set<? extends ShareReceiverType> var1) throws WrongAccessStructureException;

    default public boolean isQualified(Collection<Integer> setOfShareReceiversIds) throws WrongAccessStructureException {
        Set setOfShareReceivers = this.getShareReceiverMap().entrySet().stream().filter(entry -> setOfShareReceiversIds.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
        return this.isQualified(setOfShareReceivers);
    }

    public Zp getSharedRing();

    public Map<Integer, Zp.ZpElement> completeShares(Zp.ZpElement var1, Map<Integer, Zp.ZpElement> var2) throws IllegalArgumentException;

    public boolean checkShareConsistency(Zp.ZpElement var1, Map<Integer, Zp.ZpElement> var2);
}

