/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.secretsharing.accessstructure.utils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.cryptimeleon.craco.secretsharing.accessstructure.exceptions.WrongAccessStructureException;
import org.cryptimeleon.craco.secretsharing.accessstructure.utils.TreeNode;
import org.cryptimeleon.craco.secretsharing.accessstructure.visitors.Visitor;

public class InnerNode
implements TreeNode {
    private final ArrayList<TreeNode> children;
    private int t;

    public InnerNode() {
        this.children = new ArrayList();
        this.t = 0;
    }

    public InnerNode(ArrayList<TreeNode> children, Integer threshold) {
        this.children = children;
        this.t = threshold;
    }

    public void addChild(TreeNode child) {
        this.children.add(child);
    }

    public ArrayList<TreeNode> getChildren() {
        return new ArrayList<TreeNode>(this.children);
    }

    @Override
    public int getNumberOfChildren() {
        return this.children.size();
    }

    @Override
    public int getThreshold() {
        return this.t;
    }

    @Override
    public <F> F performVisitor(Visitor<F> visitor) throws WrongAccessStructureException {
        visitor.visit(this);
        for (TreeNode child : this.children) {
            Visitor<F> childVisitor = visitor.getVisitorForNextChild();
            F childResult = child.performVisitor(childVisitor);
            visitor.putResultOfChild(childResult);
        }
        return visitor.getResultOfCurrentNode();
    }

    public void setThreshold(Integer threshold) {
        this.t = threshold;
    }

    public String toString() {
        return "( " + this.getThreshold() + " of: " + this.children.stream().map(Object::toString).collect(Collectors.joining(",")) + " )";
    }
}

