/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.secretsharing.accessstructure.utils;

import java.math.BigInteger;
import java.util.ArrayList;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class RandomFunction {
    private final ArrayList<Zp.ZpElement> values = new ArrayList();
    private final Zp zPField;

    public RandomFunction(BigInteger deg, Zp.ZpElement zeroValue, Zp zpField) {
        this.zPField = zpField;
        this.values.add(zeroValue);
        if (!deg.equals(BigInteger.ZERO)) {
            Zp.ZpElement value;
            BigInteger counter = BigInteger.ONE;
            while (!counter.equals(deg)) {
                this.values.add(zpField.getUniformlyRandomElement());
                counter = counter.add(BigInteger.ONE);
            }
            while ((value = zpField.getUniformlyRandomElement()).isZero()) {
            }
            this.values.add(value);
        }
    }

    public Zp.ZpElement getValueFor(BigInteger x) {
        Zp.ZpElement xe = this.zPField.createZnElement(x);
        Zp.ZpElement result = this.zPField.getZeroElement();
        for (int i = this.values.size(); i > 0; --i) {
            result = this.values.get(i - 1).add((Element)result.mul((Element)xe));
        }
        return result;
    }
}

