/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.secretsharing.accessstructure.visitors;

import java.util.Set;
import org.cryptimeleon.craco.secretsharing.accessstructure.utils.LeafNode;
import org.cryptimeleon.craco.secretsharing.accessstructure.utils.TreeNode;
import org.cryptimeleon.craco.secretsharing.accessstructure.visitors.Visitor;

public class AccessGrantedVisitor
implements Visitor<Boolean> {
    private final Set<Integer> setOfShares;
    private int threshold;
    private int numberOfFulfilledChildren = 0;
    private boolean fulfilled;

    public AccessGrantedVisitor(Set<Integer> setOfShareIdentifiers) {
        this.setOfShares = setOfShareIdentifiers;
        this.fulfilled = false;
    }

    private AccessGrantedVisitor(Set<Integer> setOfShareIdentifiers, boolean fulfilled) {
        this.setOfShares = setOfShareIdentifiers;
        this.fulfilled = fulfilled;
    }

    @Override
    public Boolean getResultOfCurrentNode() {
        return this.fulfilled;
    }

    @Override
    public Visitor<Boolean> getVisitorForNextChild() {
        return new AccessGrantedVisitor(this.setOfShares, this.fulfilled);
    }

    @Override
    public void putResultOfChild(Boolean isChildFulfilled) {
        if (!this.fulfilled && isChildFulfilled.booleanValue()) {
            ++this.numberOfFulfilledChildren;
            this.fulfilled = this.numberOfFulfilledChildren == this.threshold;
        }
    }

    @Override
    public void visit(TreeNode currentNode) {
        this.threshold = currentNode.getThreshold();
        if (this.threshold == 0) {
            this.fulfilled = currentNode instanceof LeafNode ? this.setOfShares.contains(((LeafNode)currentNode).getShareIdentifier()) : true;
        }
    }
}

