/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.secretsharing.accessstructure.visitors;

import java.util.ArrayList;
import org.cryptimeleon.craco.secretsharing.accessstructure.exceptions.WrongAccessStructureException;
import org.cryptimeleon.craco.secretsharing.accessstructure.utils.TreeNode;
import org.cryptimeleon.craco.secretsharing.accessstructure.visitors.Visitor;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class MonotoneSpanProgramGetMatrixVisitor
implements Visitor<Integer> {
    private final Zp field;
    private final ArrayList<Zp.ZpElement> prefix;
    private final ArrayList<ArrayList<Zp.ZpElement>> matrix;
    private int threshold;
    private Zp.ZpElement counterN;
    private int ownOffset = 0;
    private TreeNode node;

    public MonotoneSpanProgramGetMatrixVisitor(Zp field, ArrayList<Zp.ZpElement> prefix, ArrayList<ArrayList<Zp.ZpElement>> matrix) {
        this.field = field;
        this.prefix = new ArrayList();
        for (Zp.ZpElement ele : prefix) {
            this.prefix.add(field.getOneElement().mul((Element)ele));
        }
        this.matrix = matrix;
        this.counterN = field.getZeroElement();
    }

    @Override
    public Integer getResultOfCurrentNode() {
        if (this.threshold == 0) {
            return 0;
        }
        return this.ownOffset + this.threshold - 1;
    }

    public MonotoneSpanProgramGetMatrixVisitor getVisitorForNextChild() throws WrongAccessStructureException {
        Zp.ZpElement value = this.field.getOneElement();
        this.counterN = this.counterN.add((Element)this.field.getOneElement());
        ArrayList tempPrefix = (ArrayList)this.prefix.clone();
        if (this.threshold != 0) {
            for (int counterT = 1; counterT < this.threshold; ++counterT) {
                value = value.mul((Element)this.counterN);
                tempPrefix.add(value);
            }
        } else {
            throw new WrongAccessStructureException("Tree contains a node with children and Threshold 0 \n 0 is not a valid threshold");
        }
        for (int counter = 0; counter < this.ownOffset; ++counter) {
            tempPrefix.add(this.field.getZeroElement());
        }
        return new MonotoneSpanProgramGetMatrixVisitor(this.field, tempPrefix, this.matrix);
    }

    @Override
    public void putResultOfChild(Integer input) {
        this.ownOffset += input.intValue();
    }

    @Override
    public void visit(TreeNode currentNode) {
        this.node = currentNode;
        this.threshold = this.node.getThreshold();
        int numberOfNodes = this.node.getNumberOfChildren();
        if (numberOfNodes == 0) {
            this.matrix.add(this.prefix);
        }
    }
}

