/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.secretsharing.accessstructure.visitors;

import org.cryptimeleon.craco.secretsharing.accessstructure.exceptions.WrongAccessStructureException;
import org.cryptimeleon.craco.secretsharing.accessstructure.utils.TreeNode;
import org.cryptimeleon.craco.secretsharing.accessstructure.visitors.Visitor;

public class ToStringVisitor
implements Visitor<String> {
    String output = "";
    TreeNode currentNode;
    boolean firstAttr = true;

    @Override
    public String getResultOfCurrentNode() throws WrongAccessStructureException {
        if (this.currentNode.getNumberOfChildren() == 0) {
            TreeNode leaf = this.currentNode;
            return leaf.toString();
        }
        return this.output.concat(String.format("' %d )", this.currentNode.getThreshold()));
    }

    @Override
    public Visitor<String> getVisitorForNextChild() throws WrongAccessStructureException {
        return new ToStringVisitor();
    }

    @Override
    public void putResultOfChild(String input) {
        if (this.firstAttr) {
            this.output = this.output.concat(String.format("%s", input));
            this.firstAttr = false;
        } else {
            this.output = this.output.concat(String.format(", %s", input));
        }
    }

    @Override
    public void visit(TreeNode currentNode) throws WrongAccessStructureException {
        this.currentNode = currentNode;
        this.output = new String("( ");
    }
}

