/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.bbs;

import java.util.Arrays;
import java.util.Objects;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.common.plaintexts.RingElementPlainText;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.StandardMultiMessageSignatureScheme;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.bbs.BBSABSignature;
import org.cryptimeleon.craco.sig.bbs.BBSBPublicParameter;
import org.cryptimeleon.craco.sig.bbs.BBSBSigningKey;
import org.cryptimeleon.craco.sig.bbs.BBSBVerificationKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.cartesian.RingElementVector;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class BBSBSignatureScheme
implements StandardMultiMessageSignatureScheme {
    private BBSBPublicParameter pp;

    public BBSBSignatureScheme(Representation repr) {
        this.pp = new BBSBPublicParameter(repr);
    }

    public BBSBSignatureScheme(BBSBPublicParameter pp) {
        this.pp = pp;
    }

    public Representation getRepresentation() {
        return this.pp.getRepresentation();
    }

    public SignatureKeyPair<BBSBVerificationKey, BBSBSigningKey> generateKeyPair(int numberOfMessages) {
        Zp zp = this.pp.getZp();
        GroupElement g2 = this.pp.getG2();
        Zp.ZpElement exponentGamma = zp.getUniformlyRandomUnit();
        GroupElement w = g2.pow((Zn.ZnElement)exponentGamma).compute();
        Zp.ZpElement[] ziExponents = new Zp.ZpElement[numberOfMessages + 1];
        ziExponents = (Zp.ZpElement[])Arrays.stream(ziExponents).map(a -> zp.getUniformlyRandomElement()).toArray(Zp.ZpElement[]::new);
        GroupElement[] uiG2Elements = (GroupElement[])Arrays.stream(ziExponents).map(zi -> g2.pow((Zn.ZnElement)zi).compute()).toArray(GroupElement[]::new);
        BBSBSigningKey sk = new BBSBSigningKey();
        sk.setExponentGamma(exponentGamma);
        sk.setZiExponents(ziExponents);
        BBSBVerificationKey pk = new BBSBVerificationKey();
        pk.setUiG2Elements(uiG2Elements);
        pk.setW(w);
        return new SignatureKeyPair<BBSBVerificationKey, BBSBSigningKey>(pk, sk);
    }

    @Override
    public BBSABSignature sign(PlainText plainText, SigningKey secretKey) {
        Zp.ZpElement exponentX;
        if (!(plainText instanceof MessageBlock)) {
            throw new IllegalArgumentException("Not a valid plain text for this scheme");
        }
        if (!(secretKey instanceof BBSBSigningKey)) {
            throw new IllegalArgumentException("Not a valid signing key for this scheme");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        BBSBSigningKey sk = (BBSBSigningKey)secretKey;
        if (messageBlock.length() != sk.getNumberOfMessages()) {
            throw new IllegalArgumentException("Not a valid block size for this scheme");
        }
        while ((exponentX = this.pp.getZp().getUniformlyRandomElement()).equals((Object)sk.getExponentGamma().neg())) {
        }
        Zp.ZpElement exponentSPrime = this.pp.getZp().getUniformlyRandomElement();
        Zp.ZpElement resultExponent = this.pp.getZp().getOneElement();
        resultExponent = resultExponent.add((Element)sk.getZiExponents()[0].mul((Element)exponentSPrime));
        for (int i = 1; i <= sk.getNumberOfMessages(); ++i) {
            resultExponent = resultExponent.add((Element)sk.getZiExponents()[i].mul((Element)((Zp.ZpElement)((RingElementPlainText)messageBlock.get(i - 1)).getRingElement())));
        }
        GroupElement c = this.pp.getG1();
        c = c.pow((Zn.ZnElement)resultExponent);
        Zp.ZpElement exponent = exponentX.add((Element)sk.getExponentGamma()).inv();
        GroupElement signatureElementA = c.pow((Zn.ZnElement)exponent).compute();
        return new BBSABSignature(signatureElementA, (Zn.ZnElement)exponentX, (Zn.ZnElement)exponentSPrime);
    }

    @Override
    public Boolean verify(PlainText plainText, Signature signature, VerificationKey publicKey) {
        if (!(plainText instanceof MessageBlock)) {
            throw new IllegalArgumentException("Not a valid plain text for this scheme");
        }
        if (!(signature instanceof BBSABSignature)) {
            throw new IllegalArgumentException("Not a valid signature for this scheme");
        }
        if (!(publicKey instanceof BBSBVerificationKey)) {
            throw new IllegalArgumentException("Not a valid public key for this scheme");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        BBSBVerificationKey pk = (BBSBVerificationKey)publicKey;
        BBSABSignature sigma = (BBSABSignature)signature;
        GroupElement rebuildC = this.pp.getG1();
        rebuildC = rebuildC.op((Element)((GroupElement)this.pp.getGroupHom().apply((Object)pk.getUiG2Elements()[0])).pow(sigma.getExponentS()));
        for (int i = 1; i <= pk.getNumberOfMessages(); ++i) {
            rebuildC = rebuildC.op((Element)pk.getUiG2Elements()[i].pow((Zn.ZnElement)((Zp.ZpElement)((RingElementPlainText)messageBlock.get(i - 1)).getRingElement())));
        }
        GroupElement g2 = this.pp.getG2();
        GroupElement rightHandSide = this.pp.getBilinearMap().apply(rebuildC, g2);
        GroupElement leftHandSide = this.pp.getBilinearMap().apply(sigma.getElementA(), pk.getW().op((Element)g2.pow(sigma.getExponentX())));
        return leftHandSide.equals(rightHandSide);
    }

    @Override
    public MessageBlock restorePlainText(Representation repr) {
        return new MessageBlock(repr, RingElementPlainText::new);
    }

    @Override
    public BBSABSignature restoreSignature(Representation repr) {
        return new BBSABSignature(repr, this.pp.getGroupG1());
    }

    @Override
    public BBSBSigningKey restoreSigningKey(Representation repr) {
        return new BBSBSigningKey(repr, this.pp.getZp());
    }

    @Override
    public BBSBVerificationKey restoreVerificationKey(Representation repr) {
        return new BBSBVerificationKey(repr, this.pp.getGroupG2());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pp == null ? 0 : this.pp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BBSBSignatureScheme other = (BBSBSignatureScheme)obj;
        return Objects.equals(this.pp, other.pp);
    }

    @Override
    public PlainText mapToPlaintext(byte[] bytes, VerificationKey pk) {
        return this.mapToPlaintext(bytes, ((BBSBVerificationKey)pk).getNumberOfMessages());
    }

    @Override
    public PlainText mapToPlaintext(byte[] bytes, SigningKey sk) {
        return this.mapToPlaintext(bytes, ((BBSBSigningKey)sk).getNumberOfMessages());
    }

    @Override
    public int getMaxNumberOfBytesForMapToPlaintext() {
        return (this.pp.getGroupG1().size().bitLength() - 1) / 8;
    }

    protected MessageBlock mapToPlaintext(byte[] bytes, int messageBlockLength) {
        return (MessageBlock)new RingElementVector(new RingElement[]{this.pp.getZp().injectiveValueOf(bytes)}).pad((RingElement)this.pp.getZp().getZeroElement(), messageBlockLength).map(RingElementPlainText::new, MessageBlock::new);
    }

    public BBSBPublicParameter getPublicParameters() {
        return this.pp;
    }
}

