/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.ps;

import org.cryptimeleon.craco.commitment.CommitmentScheme;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.RingElementPlainText;
import org.cryptimeleon.craco.protocols.CommonInput;
import org.cryptimeleon.craco.protocols.SecretInput;
import org.cryptimeleon.craco.protocols.arguments.damgardtechnique.DamgardTechnique;
import org.cryptimeleon.craco.protocols.arguments.sigma.ZnChallengeSpace;
import org.cryptimeleon.craco.protocols.arguments.sigma.instance.SigmaProtocolInstance;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.DelegateProtocol;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.LinearStatementFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.SendThenDelegateFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrZnVariable;
import org.cryptimeleon.craco.protocols.base.BaseProtocol;
import org.cryptimeleon.craco.protocols.base.BaseProtocolInstance;
import org.cryptimeleon.craco.sig.ps.PSExtendedSignatureScheme;
import org.cryptimeleon.craco.sig.ps.PSExtendedVerificationKey;
import org.cryptimeleon.craco.sig.ps.PSSignature;
import org.cryptimeleon.craco.sig.ps.PSSigningKey;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.cartesian.ExponentExpressionVector;
import org.cryptimeleon.math.structures.cartesian.Vector;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.cartesian.GroupElementVector;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.rings.cartesian.RingElementVector;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class PSBlindSignProtocol
extends BaseProtocol {
    protected final CommitmentScheme commitmentSchemeForDamgard;
    protected final PSExtendedSignatureScheme scheme;

    public PSBlindSignProtocol(PSExtendedSignatureScheme scheme, CommitmentScheme commitmentSchemeForDamgard) {
        super("receiver", "signer");
        this.commitmentSchemeForDamgard = commitmentSchemeForDamgard;
        this.scheme = scheme;
    }

    public static CommitmentScheme generatePp(PSExtendedSignatureScheme scheme) {
        return DamgardTechnique.generateCommitmentScheme(scheme.pp.getBilinearGroup().getG1());
    }

    @Override
    public BlindSignProtocolInstance instantiateProtocol(String role, CommonInput commonInput, SecretInput secretInput) {
        return new BlindSignProtocolInstance(this, role, (PSExtendedVerificationKey)commonInput, secretInput);
    }

    public BlindSignProtocolInstance instantiateProtocolForSigner(PSExtendedVerificationKey commonInput, PSSigningKey secretInput) {
        return this.instantiateProtocol("signer", commonInput, secretInput);
    }

    public BlindSignProtocolInstance instantiateProtocolForReceiver(PSExtendedVerificationKey commonInput, ReceiverInput secretInput) {
        return this.instantiateProtocol("receiver", commonInput, secretInput);
    }

    public static class BlindSignProtocolInstance
    extends BaseProtocolInstance {
        private final BilinearGroup group;
        private final Zn zn;
        private final PSExtendedVerificationKey commonInput;
        private final ReceiverInput receiverInput;
        private final PSSigningKey signerInput;
        private final PSBlindSignProtocol protocol;
        private GroupElement commitment;
        private Zn.ZnElement blindingFactor;
        private PSSignature resultSignature;
        private SigmaProtocolInstance openingProofInstance;

        public BlindSignProtocolInstance(PSBlindSignProtocol protocol, String role, PSExtendedVerificationKey commonInput, SecretInput secretInput) {
            super(protocol, role);
            this.protocol = protocol;
            this.commonInput = commonInput;
            this.group = protocol.scheme.pp.getBilinearGroup();
            this.zn = this.group.getZn();
            this.receiverInput = role.equals("receiver") ? (ReceiverInput)secretInput : null;
            this.signerInput = role.equals("signer") ? (PSSigningKey)secretInput : null;
        }

        @Override
        protected void doRoundForFirstRole(int round) {
            switch (round) {
                case 0: {
                    this.blindingFactor = this.zn.getUniformlyRandomElement();
                    this.commitment = this.commonInput.getGroup1ElementsYi().innerProduct((Vector)this.receiverInput.message).op((Element)this.commonInput.getGroup1ElementG().pow(this.blindingFactor));
                    this.send("commitment", this.commitment.getRepresentation());
                    this.openingProofInstance = new DamgardTechnique(new OpeningProof(), this.protocol.commitmentSchemeForDamgard).getProverInstance(new OpeningCommonInput(this.commitment), new OpeningSecretInput(this.receiverInput.message, this.blindingFactor));
                    this.runSubprotocolConcurrently("openingProof", this.openingProofInstance);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    GroupElement sigma0 = this.group.getG1().restoreElement(this.receive("sigma0"));
                    GroupElement sigma1 = this.group.getG1().restoreElement(this.receive("blindedSigma1")).op((Element)sigma0.pow(this.blindingFactor.neg()));
                    this.resultSignature = new PSSignature(sigma0, sigma1);
                    this.terminate();
                }
            }
        }

        @Override
        protected void doRoundForSecondRole(int round) {
            switch (round) {
                case 1: {
                    this.commitment = this.group.getG1().restoreElement(this.receive("commitment"));
                    this.openingProofInstance = new DamgardTechnique(new OpeningProof(), this.protocol.commitmentSchemeForDamgard).getVerifierInstance(new OpeningCommonInput(this.commitment));
                    this.runSubprotocolConcurrently("openingProof", this.openingProofInstance);
                    break;
                }
                case 3: {
                    if (!this.openingProofInstance.isAccepting()) {
                        throw new IllegalStateException("Proof was not accepted");
                    }
                    Zn.ZnElement r = this.zn.getUniformlyRandomNonzeroElement();
                    GroupElement sigma0 = this.commonInput.getGroup1ElementG().pow(r);
                    this.send("sigma0", sigma0.getRepresentation());
                    this.send("blindedSigma1", this.commitment.op((Element)this.commonInput.getGroup1ElementG().pow((Zn.ZnElement)this.signerInput.getExponentX())).pow(r).getRepresentation());
                    this.terminate();
                }
            }
        }

        public PSSignature getResultSignature() {
            return this.resultSignature;
        }

        public static class OpeningSecretInput
        implements SecretInput {
            public final RingElementVector message;
            public final Zn.ZnElement blindingFactor;

            public OpeningSecretInput(RingElementVector message, Zn.ZnElement blindingFactor) {
                this.message = message;
                this.blindingFactor = blindingFactor;
            }
        }

        public static class OpeningCommonInput
        implements CommonInput {
            public final GroupElement commitment;

            public OpeningCommonInput(GroupElement commitment) {
                this.commitment = commitment;
            }
        }

        public class OpeningProof
        extends DelegateProtocol {
            @Override
            protected SendThenDelegateFragment.SubprotocolSpec provideSubprotocolSpec(CommonInput commonInput, SendThenDelegateFragment.SubprotocolSpecBuilder builder) {
                ExponentExpressionVector msgVars = (ExponentExpressionVector)BlindSignProtocolInstance.this.commonInput.getGroup1ElementsYi().map((i, m) -> builder.addZnVariable("m" + i, BlindSignProtocolInstance.this.zn), ExponentExpressionVector::new);
                SchnorrZnVariable blindVar = builder.addZnVariable("blindingFactor", BlindSignProtocolInstance.this.zn);
                GroupElementVector group1Yi = BlindSignProtocolInstance.this.commonInput.getGroup1ElementsYi();
                GroupElement g1 = BlindSignProtocolInstance.this.commonInput.getGroup1ElementG();
                builder.addSubprotocol("knowledgeOfOpening", new LinearStatementFragment(group1Yi.expr().innerProduct((Vector)msgVars).op(g1.pow((ExponentExpr)blindVar)).isEqualTo(((OpeningCommonInput)commonInput).commitment)));
                return builder.build();
            }

            @Override
            protected SendThenDelegateFragment.ProverSpec provideProverSpecWithNoSendFirst(CommonInput commonInput, SecretInput secretInput1, SendThenDelegateFragment.ProverSpecBuilder builder) {
                OpeningSecretInput secretInput = (OpeningSecretInput)secretInput1;
                secretInput.message.forEach((i, m) -> builder.putWitnessValue("m" + i, (Zn.ZnElement)m));
                builder.putWitnessValue("blindingFactor", secretInput.blindingFactor);
                return builder.build();
            }

            @Override
            public ZnChallengeSpace getChallengeSpace(CommonInput commonInput) {
                return new ZnChallengeSpace(((BlindSignProtocolInstance)BlindSignProtocolInstance.this).protocol.scheme.pp.getBilinearGroup().getZn());
            }
        }
    }

    public static class ReceiverInput
    implements SecretInput {
        public final RingElementVector message;

        public ReceiverInput(RingElementVector message) {
            this.message = message;
        }

        public ReceiverInput(MessageBlock message) {
            this((RingElementVector)message.map(pt -> ((RingElementPlainText)pt).getRingElement(), RingElementVector::new));
        }
    }
}

