/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.ps;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.common.plaintexts.RingElementPlainText;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.StandardMultiMessageSignatureScheme;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.ps.PSPublicParameters;
import org.cryptimeleon.craco.sig.ps.PSSignature;
import org.cryptimeleon.craco.sig.ps.PSSigningKey;
import org.cryptimeleon.craco.sig.ps.PSVerificationKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.cartesian.Vector;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.cartesian.GroupElementVector;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.cartesian.RingElementVector;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class PSSignatureScheme
implements StandardMultiMessageSignatureScheme {
    @Represented
    protected PSPublicParameters pp;

    public PSSignatureScheme(PSPublicParameters pp) {
        this.pp = pp;
    }

    public PSSignatureScheme(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    public SignatureKeyPair<? extends PSVerificationKey, ? extends PSSigningKey> generateKeyPair(int numberOfMessages) {
        BigInteger size = this.pp.getBilinearMap().getG1().size();
        Group group2 = this.pp.getBilinearMap().getG2();
        Zp zp = new Zp(size);
        GroupElement group2ElementTildeG = group2.getUniformlyRandomNonNeutral().compute();
        Zp.ZpElement exponentX = zp.getUniformlyRandomElement();
        RingElementVector exponentsYi = zp.getUniformlyRandomElements(numberOfMessages);
        GroupElement group2ElementX = group2ElementTildeG.pow((Zn.ZnElement)exponentX).compute();
        GroupElementVector group2ElementsYi = group2ElementTildeG.pow((Vector)exponentsYi);
        PSSigningKey sk = new PSSigningKey(exponentX, exponentsYi);
        PSVerificationKey pk = new PSVerificationKey(group2ElementTildeG, group2ElementX, group2ElementsYi);
        return new SignatureKeyPair<PSVerificationKey, PSSigningKey>(pk, sk);
    }

    @Override
    public Signature sign(PlainText plainText, SigningKey secretKey) {
        if (plainText instanceof RingElementPlainText) {
            plainText = new MessageBlock(plainText);
        }
        if (!(plainText instanceof MessageBlock)) {
            throw new IllegalArgumentException("Not a valid plain text for this scheme");
        }
        if (!(secretKey instanceof PSSigningKey)) {
            throw new IllegalArgumentException("Not a valid signing key for this scheme");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        PSSigningKey sk = (PSSigningKey)secretKey;
        if (messageBlock.length() != sk.getNumberOfMessages()) {
            throw new IllegalArgumentException("Not a valid block size for this scheme");
        }
        GroupElement group1ElementH = this.pp.getBilinearMap().getG1().getUniformlyRandomNonNeutral().compute();
        Zp.ZpElement resultExponent = sk.getExponentX().add((Element)((RingElementVector)((MessageBlock)plainText).map(pt -> ((RingElementPlainText)pt).getRingElement(), RingElementVector::new)).innerProduct((Vector)sk.getExponentsYi()));
        GroupElement group1ElementSigma2 = group1ElementH.pow(resultExponent.getInteger()).compute();
        return new PSSignature(group1ElementH, group1ElementSigma2);
    }

    @Override
    public Boolean verify(PlainText plainText, Signature signature, VerificationKey publicKey) {
        if (plainText instanceof RingElementPlainText) {
            plainText = new MessageBlock(plainText);
        }
        if (!(plainText instanceof MessageBlock)) {
            throw new IllegalArgumentException("Not a valid plain text for this scheme");
        }
        if (!(signature instanceof PSSignature)) {
            throw new IllegalArgumentException("Not a valid signature for this scheme");
        }
        if (!(publicKey instanceof PSVerificationKey)) {
            throw new IllegalArgumentException("Not a valid public key for this scheme");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        PSVerificationKey pk = (PSVerificationKey)publicKey;
        PSSignature sigma = (PSSignature)signature;
        if (sigma.getGroup1ElementSigma1().isNeutralElement()) {
            return false;
        }
        GroupElement rightHandSide = this.pp.getBilinearMap().apply(sigma.getGroup1ElementSigma2(), pk.getGroup2ElementTildeG());
        GroupElement group2Elem = pk.getGroup2ElementTildeX().op((Element)pk.getGroup2ElementsTildeYi().innerProduct(messageBlock.map(pt -> ((RingElementPlainText)pt).getRingElement(), RingElementVector::new)));
        GroupElement leftHandSide = this.pp.getBilinearMap().apply(sigma.getGroup1ElementSigma1(), group2Elem);
        return leftHandSide.equals(rightHandSide);
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    @Override
    public MessageBlock restorePlainText(Representation repr) {
        return new MessageBlock(repr, RingElementPlainText::new);
    }

    @Override
    public PSSignature restoreSignature(Representation repr) {
        return new PSSignature(repr, this.pp.getBilinearMap().getG1());
    }

    @Override
    public PSSigningKey restoreSigningKey(Representation repr) {
        return new PSSigningKey(repr, this.pp.getZp());
    }

    @Override
    public PSVerificationKey restoreVerificationKey(Representation repr) {
        return new PSVerificationKey(this.pp.getBilinearMap().getG2(), repr);
    }

    public PSPublicParameters getPp() {
        return this.pp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pp == null ? 0 : this.pp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PSSignatureScheme other = (PSSignatureScheme)obj;
        return Objects.equals(this.pp, other.pp);
    }

    @Override
    public MessageBlock mapToPlaintext(byte[] bytes, VerificationKey pk) {
        return this.mapToPlaintext(bytes, ((PSVerificationKey)pk).getNumberOfMessages());
    }

    @Override
    public MessageBlock mapToPlaintext(byte[] bytes, SigningKey sk) {
        return this.mapToPlaintext(bytes, ((PSSigningKey)sk).getNumberOfMessages());
    }

    @Override
    public int getMaxNumberOfBytesForMapToPlaintext() {
        return (this.pp.getBilinearMap().getG1().size().bitLength() - 1) / 8;
    }

    protected MessageBlock mapToPlaintext(byte[] bytes, int messageBlockLength) {
        return (MessageBlock)new RingElementVector(new RingElement[]{this.pp.getZp().injectiveValueOf(bytes)}).pad((RingElement)this.pp.getZp().getZeroElement(), messageBlockLength).map(RingElementPlainText::new, MessageBlock::new);
    }
}

