/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.ps18;

import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.common.plaintexts.RingElementPlainText;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.ps.PSPublicParameters;
import org.cryptimeleon.craco.sig.ps18.PS18ROMSignature;
import org.cryptimeleon.craco.sig.ps18.PS18SignatureScheme;
import org.cryptimeleon.craco.sig.ps18.PS18SigningKey;
import org.cryptimeleon.craco.sig.ps18.PS18VerificationKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.rings.zn.HashIntoZp;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class PS18ROMSignatureScheme
extends PS18SignatureScheme {
    public PS18ROMSignatureScheme(PSPublicParameters pp) {
        super(pp);
    }

    public PS18ROMSignatureScheme(Representation repr) {
        super(repr);
    }

    @Override
    public Signature sign(PlainText plainText, SigningKey secretKey) {
        if (plainText instanceof RingElementPlainText) {
            plainText = new MessageBlock(plainText);
        }
        if (!(plainText instanceof MessageBlock)) {
            throw new IllegalArgumentException("Plaintext is not a 'MessageBlock' instance.");
        }
        if (!(secretKey instanceof PS18SigningKey)) {
            throw new IllegalArgumentException("Signing key is not a 'PS18SigningKey' instance.");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        PS18SigningKey sk = (PS18SigningKey)secretKey;
        if (messageBlock.length() != sk.getNumberOfMessages()) {
            throw new IllegalArgumentException("Message length does not match length supported by signing key.");
        }
        Zp zp = this.pp.getZp();
        GroupElement group1ElementSigma1 = this.pp.getBilinearMap().getG1().getUniformlyRandomNonNeutral().compute();
        Zp.ZpElement exponentPrimeM = this.romHashIntoZp(messageBlock, zp);
        PS18SignatureScheme ps18SigScheme = new PS18SignatureScheme(this.pp);
        GroupElement group1ElementSigma2 = ps18SigScheme.computeSigma2(messageBlock, sk, exponentPrimeM, group1ElementSigma1).compute();
        return new PS18ROMSignature(group1ElementSigma1, group1ElementSigma2);
    }

    @Override
    public Boolean verify(PlainText plainText, Signature signature, VerificationKey publicKey) {
        if (plainText instanceof RingElementPlainText) {
            plainText = new MessageBlock(plainText);
        }
        if (!(plainText instanceof MessageBlock)) {
            throw new IllegalArgumentException("Plaintext is not a 'MessageBlock' instance.");
        }
        if (!(signature instanceof PS18ROMSignature)) {
            throw new IllegalArgumentException("Signature is not a 'PS18Signature' instance.");
        }
        if (!(publicKey instanceof PS18VerificationKey)) {
            throw new IllegalArgumentException("Public key is not a 'PS18VerificationKey' instance.");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        PS18VerificationKey pk = (PS18VerificationKey)publicKey;
        PS18ROMSignature sigma = (PS18ROMSignature)signature;
        if (sigma.getGroup1ElementSigma1().isNeutralElement()) {
            return false;
        }
        Zp zp = this.pp.getZp();
        GroupElement rightHandSide = this.pp.getBilinearMap().apply(sigma.getGroup1ElementSigma2(), pk.getGroup2ElementTildeG());
        PS18SignatureScheme ps18SigScheme = new PS18SignatureScheme(this.pp);
        GroupElement leftHandSide = ps18SigScheme.computeLeftHandSide(messageBlock, pk, this.romHashIntoZp(messageBlock, zp), sigma.getGroup1ElementSigma1());
        return leftHandSide.equals(rightHandSide);
    }

    @Override
    public Signature restoreSignature(Representation repr) {
        return new PS18ROMSignature(repr, this.pp.getBilinearMap().getG1());
    }

    private Zp.ZpElement romHashIntoZp(MessageBlock messages, Zp zp) {
        byte[] messageBytes = messages.getUniqueByteRepresentation();
        return new HashIntoZp(zp).hash(messageBytes);
    }
}

