/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.ps18;

import java.util.Objects;
import java.util.stream.IntStream;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.common.plaintexts.RingElementPlainText;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.ps.PSPublicParameters;
import org.cryptimeleon.craco.sig.ps18.PS18Signature;
import org.cryptimeleon.craco.sig.ps18.PS18SigningKey;
import org.cryptimeleon.craco.sig.ps18.PS18VerificationKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.cartesian.GroupElementVector;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.cartesian.RingElementVector;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class PS18SignatureScheme
implements SignatureScheme {
    @Represented
    PSPublicParameters pp;

    public PS18SignatureScheme(PSPublicParameters pp) {
        this.pp = pp;
    }

    public PS18SignatureScheme(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public SignatureKeyPair<PS18VerificationKey, PS18SigningKey> generateKeyPair(int numberOfMessages) {
        Group group2 = this.pp.getBilinearMap().getG2();
        Zp zp = this.pp.getZp();
        GroupElement group2ElementTildeG = group2.getUniformlyRandomNonNeutral().compute();
        Zp.ZpElement exponentX = zp.getUniformlyRandomUnit();
        RingElementVector exponentsYi = RingElementVector.fromStream(IntStream.range(0, numberOfMessages + 1).mapToObj(a -> zp.getUniformlyRandomUnit()));
        GroupElement group2ElementTildeX = group2ElementTildeG.pow((Zn.ZnElement)exponentX).compute();
        GroupElementVector group2ElementsTildeYi = new GroupElementVector(exponentsYi.map(x -> group2ElementTildeG.pow((Zn.ZnElement)((Zp.ZpElement)x)).compute()));
        group2ElementTildeX.precomputePow();
        group2ElementsTildeYi.precomputePow();
        PS18SigningKey sk = new PS18SigningKey(exponentX, exponentsYi);
        PS18VerificationKey pk = new PS18VerificationKey(group2ElementTildeG, group2ElementTildeX, group2ElementsTildeYi);
        return new SignatureKeyPair<PS18VerificationKey, PS18SigningKey>(pk, sk);
    }

    @Override
    public Signature sign(PlainText plainText, SigningKey secretKey) {
        if (plainText instanceof RingElementPlainText) {
            plainText = new MessageBlock(plainText);
        }
        if (!(plainText instanceof MessageBlock)) {
            throw new IllegalArgumentException("Plaintext is not a 'MessageBlock' instance.");
        }
        if (!(secretKey instanceof PS18SigningKey)) {
            throw new IllegalArgumentException("Signing key is not a 'PS18SigningKey' instance.");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        PS18SigningKey sk = (PS18SigningKey)secretKey;
        if (messageBlock.length() != sk.getNumberOfMessages()) {
            throw new IllegalArgumentException("Message length does not match length supported by signing key.");
        }
        Zp zp = this.pp.getZp();
        GroupElement group1ElementSigma1 = this.pp.getBilinearMap().getG1().getUniformlyRandomNonNeutral();
        Zp.ZpElement exponentPrimeM = zp.getUniformlyRandomElement();
        GroupElement group1ElementSigma2 = this.computeSigma2(messageBlock, sk, exponentPrimeM, group1ElementSigma1);
        return new PS18Signature(exponentPrimeM, group1ElementSigma1, group1ElementSigma2);
    }

    @Override
    public Boolean verify(PlainText plainText, Signature signature, VerificationKey publicKey) {
        if (plainText instanceof RingElementPlainText) {
            plainText = new MessageBlock(plainText);
        }
        if (!(plainText instanceof MessageBlock)) {
            throw new IllegalArgumentException("Plaintext is not a 'MessageBlock' instance.");
        }
        if (!(signature instanceof PS18Signature)) {
            throw new IllegalArgumentException("Signature is not a 'PS18Signature' instance.");
        }
        if (!(publicKey instanceof PS18VerificationKey)) {
            throw new IllegalArgumentException("Public key is not a 'PS18VerificationKey' instance.");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        PS18VerificationKey pk = (PS18VerificationKey)publicKey;
        PS18Signature sigma = (PS18Signature)signature;
        if (sigma.getGroup1ElementSigma1().isNeutralElement()) {
            return false;
        }
        GroupElement rightHandSide = this.pp.getBilinearMap().apply(sigma.getGroup1ElementSigma2(), pk.getGroup2ElementTildeG());
        GroupElement leftHandSide = this.computeLeftHandSide(messageBlock, pk, sigma.getExponentPrimeM(), sigma.getGroup1ElementSigma1());
        return leftHandSide.equals(rightHandSide);
    }

    protected GroupElement computeSigma2(MessageBlock messageBlock, PS18SigningKey sk, Zp.ZpElement exponentPrimeM, GroupElement sigma1) {
        Zp.ZpElement resultExponent = sk.getExponentX();
        for (int i = 0; i < sk.getNumberOfMessages(); ++i) {
            if (messageBlock.get(i) == null) {
                throw new IllegalArgumentException(String.format("%d'th message element is null.", i));
            }
            PlainText messagePartI = (PlainText)messageBlock.get(i);
            if (!(messagePartI instanceof RingElementPlainText)) {
                throw new IllegalArgumentException(String.format("%d'th message element is not a 'RingElementPlainText' instance.", i));
            }
            RingElementPlainText messageRingElement = (RingElementPlainText)messagePartI;
            if (!messageRingElement.getRingElement().getStructure().equals(this.pp.getZp())) {
                throw new IllegalArgumentException(String.format("%d'th message element is not an element of Zp.", i));
            }
            Zp.ZpElement messageElement = (Zp.ZpElement)messageRingElement.getRingElement();
            resultExponent = resultExponent.add((Element)((RingElement)sk.getExponentsYi().get(i)).mul((Element)messageElement));
        }
        resultExponent = resultExponent.add((Element)((RingElement)sk.getExponentsYi().get(sk.getNumberOfMessages())).mul((Element)exponentPrimeM));
        return sigma1.pow(resultExponent.getInteger());
    }

    protected GroupElement computeLeftHandSide(MessageBlock messageBlock, PS18VerificationKey pk, Zp.ZpElement exponentPrimeM, GroupElement sigma1) {
        GroupElement leftGroup2Elem = pk.getGroup2ElementTildeX();
        for (int i = 0; i < pk.getNumberOfMessages(); ++i) {
            if (messageBlock.get(i) == null) {
                throw new IllegalArgumentException(String.format("%d'th message element is null.", i));
            }
            PlainText messagePartI = (PlainText)messageBlock.get(i);
            if (!(messagePartI instanceof RingElementPlainText)) {
                throw new IllegalArgumentException(String.format("%d'th message element is not a 'RingElementPlainText' instance.", i));
            }
            RingElementPlainText messageRingElement = (RingElementPlainText)messagePartI;
            if (!messageRingElement.getRingElement().getStructure().equals(this.pp.getZp())) {
                throw new IllegalArgumentException(String.format("%d'th message element is not an element of Zp.", i));
            }
            Zp.ZpElement messageElement = (Zp.ZpElement)messageRingElement.getRingElement();
            leftGroup2Elem = leftGroup2Elem.op((Element)((GroupElement)pk.getGroup2ElementsTildeYi().get(i)).pow((Zn.ZnElement)messageElement));
        }
        leftGroup2Elem = leftGroup2Elem.op((Element)((GroupElement)pk.getGroup2ElementsTildeYi().get(pk.getNumberOfMessages())).pow((Zn.ZnElement)exponentPrimeM));
        return this.pp.getBilinearMap().apply(sigma1, leftGroup2Elem);
    }

    @Override
    public PlainText mapToPlaintext(byte[] bytes, SigningKey sk) {
        return this.mapToPlaintext(bytes, ((PS18SigningKey)sk).getNumberOfMessages());
    }

    @Override
    public PlainText mapToPlaintext(byte[] bytes, VerificationKey pk) {
        return this.mapToPlaintext(bytes, ((PS18VerificationKey)pk).getNumberOfMessages());
    }

    @Override
    public int getMaxNumberOfBytesForMapToPlaintext() {
        return (this.pp.getZp().size().bitLength() - 1) / 8;
    }

    protected MessageBlock mapToPlaintext(byte[] bytes, int messageBlockLength) {
        return (MessageBlock)new RingElementVector(new RingElement[]{this.pp.getZp().injectiveValueOf(bytes)}).pad((RingElement)this.pp.getZp().getZeroElement(), messageBlockLength).map(RingElementPlainText::new, MessageBlock::new);
    }

    @Override
    public PlainText restorePlainText(Representation repr) {
        return new MessageBlock(repr, RingElementPlainText::new);
    }

    @Override
    public Signature restoreSignature(Representation repr) {
        return new PS18Signature(repr, this.pp.getZp(), this.pp.getBilinearMap().getG1());
    }

    @Override
    public SigningKey restoreSigningKey(Representation repr) {
        return new PS18SigningKey(repr, this.pp.getZp());
    }

    @Override
    public VerificationKey restoreVerificationKey(Representation repr) {
        return new PS18VerificationKey(repr, this.pp.getBilinearMap().getG2());
    }

    public PSPublicParameters getPp() {
        return this.pp;
    }

    public int hashCode() {
        return this.pp.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PS18SignatureScheme other = (PS18SignatureScheme)obj;
        return Objects.equals(this.pp, other.pp);
    }
}

