/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.eq;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.StructurePreservingSignatureEQScheme;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.sps.eq.SPSEQPublicParameters;
import org.cryptimeleon.craco.sig.sps.eq.SPSEQSignature;
import org.cryptimeleon.craco.sig.sps.eq.SPSEQSigningKey;
import org.cryptimeleon.craco.sig.sps.eq.SPSEQVerificationKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class SPSEQSignatureScheme
implements StructurePreservingSignatureEQScheme {
    @Represented
    protected SPSEQPublicParameters pp;

    protected SPSEQSignatureScheme() {
    }

    public SPSEQSignatureScheme(SPSEQPublicParameters pp) {
        this.pp = pp;
    }

    public SPSEQSignatureScheme(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    public SignatureKeyPair<SPSEQVerificationKey, SPSEQSigningKey> generateKeyPair(int numberOfMessages) {
        Zp zp = this.pp.getZp();
        GroupElement group2ElementTildeG = this.pp.getGroup2ElementHatP();
        if (numberOfMessages <= 1) {
            throw new IllegalArgumentException("Number of messages l has to be greater 1, but it is: " + numberOfMessages);
        }
        Zp.ZpElement[] exponentsXi = (Zp.ZpElement[])IntStream.range(0, numberOfMessages).mapToObj(a -> zp.getUniformlyRandomElement()).toArray(Zp.ZpElement[]::new);
        GroupElement[] group2ElementsHatXi = (GroupElement[])Arrays.stream(exponentsXi).map(x -> group2ElementTildeG.pow((Zn.ZnElement)x).compute()).toArray(GroupElement[]::new);
        SPSEQSigningKey sk = new SPSEQSigningKey();
        sk.setExponentsXi(exponentsXi);
        SPSEQVerificationKey pk = new SPSEQVerificationKey();
        pk.setGroup2ElementsHatXi(group2ElementsHatXi);
        return new SignatureKeyPair<SPSEQVerificationKey, SPSEQSigningKey>(pk, sk);
    }

    @Override
    public Signature sign(PlainText plainText, SigningKey secretKey) {
        if (plainText instanceof GroupElementPlainText) {
            plainText = new MessageBlock(plainText);
        }
        if (!(plainText instanceof MessageBlock)) {
            throw new IllegalArgumentException("Not a valid plain text for this scheme");
        }
        if (!(secretKey instanceof SPSEQSigningKey)) {
            throw new IllegalArgumentException("Not a valid signing key for this scheme");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        SPSEQSigningKey sk = (SPSEQSigningKey)secretKey;
        if (messageBlock.length() != sk.getNumberOfMessages()) {
            throw new IllegalArgumentException("Not a valid block size for this scheme. Has to be " + sk.getNumberOfMessages() + ", but it is" + messageBlock.length());
        }
        if (messageBlock.length() <= 1) {
            throw new IllegalArgumentException("Number of messages l has to be greater 1, but it is: " + messageBlock.length());
        }
        GroupElement group1ElementZ = this.pp.getBilinearMap().getG1().getNeutralElement();
        Zp.ZpElement y = this.pp.getZp().getUniformlyRandomUnit();
        for (int i = 0; i < sk.getNumberOfMessages(); ++i) {
            if (!(messageBlock.get(i) instanceof GroupElementPlainText) || messageBlock.get(i) == null || !((GroupElementPlainText)messageBlock.get(i)).get().getStructure().equals(this.pp.getBilinearMap().getG1())) {
                throw new IllegalArgumentException("Not a valid plain text for this scheme");
            }
            group1ElementZ = group1ElementZ.op((Element)((GroupElementPlainText)messageBlock.get(i)).get().pow((Zn.ZnElement)sk.getExponentsXi()[i]));
        }
        group1ElementZ = group1ElementZ.pow((Zn.ZnElement)y);
        GroupElement sigmaZ = group1ElementZ.compute();
        GroupElement sigmaY = this.pp.getGroup1ElementP().pow((Zn.ZnElement)y.inv()).compute();
        GroupElement sigmaHatY = this.pp.getGroup2ElementHatP().pow((Zn.ZnElement)y.inv()).compute();
        return new SPSEQSignature(sigmaZ, sigmaY, sigmaHatY);
    }

    @Override
    public Boolean verify(PlainText plainText, Signature signature, VerificationKey publicKey) {
        if (plainText instanceof GroupElementPlainText) {
            plainText = new MessageBlock(plainText);
        }
        if (!(plainText instanceof MessageBlock)) {
            throw new IllegalArgumentException("Not a valid plain text for this scheme");
        }
        if (!(signature instanceof SPSEQSignature)) {
            throw new IllegalArgumentException("Not a valid signature for this scheme");
        }
        if (!(publicKey instanceof SPSEQVerificationKey)) {
            throw new IllegalArgumentException("Not a valid public key for this scheme");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        SPSEQVerificationKey pk = (SPSEQVerificationKey)publicKey;
        SPSEQSignature sigma = (SPSEQSignature)signature;
        if (sigma.getGroup1ElementSigma2Y().isNeutralElement() || sigma.getGroup1ElementSigma3HatY().isNeutralElement()) {
            return false;
        }
        GroupElement firstPPE = this.pp.getBilinearMap().apply(sigma.getGroup1ElementSigma1Z(), sigma.getGroup1ElementSigma3HatY()).inv();
        for (int i = 0; i < pk.getNumberOfMessages(); ++i) {
            firstPPE = firstPPE.op((Element)this.pp.getBilinearMap().apply(((GroupElementPlainText)messageBlock.get(i)).get(), pk.getGroup2ElementsHatXi()[i]));
        }
        firstPPE.compute();
        GroupElement secondPPE = this.pp.getBilinearMap().apply(this.pp.getGroup1ElementP(), sigma.getGroup1ElementSigma3HatY()).inv();
        secondPPE = secondPPE.op((Element)this.pp.getBilinearMap().apply(sigma.getGroup1ElementSigma2Y(), this.pp.getGroup2ElementHatP()));
        secondPPE.compute();
        GroupElement neutral = this.pp.getBilinearMap().getGT().getNeutralElement();
        return firstPPE.equals(neutral) && secondPPE.equals(neutral);
    }

    @Override
    public Signature chgRep(Signature signature, Zn.ZnElement mu, VerificationKey publicKey) {
        if (!(signature instanceof SPSEQSignature)) {
            throw new IllegalArgumentException("Not a valid signature for this scheme");
        }
        if (!(publicKey instanceof SPSEQVerificationKey)) {
            throw new IllegalArgumentException("Not a valid public key for this scheme");
        }
        if (!(mu instanceof Zp.ZpElement)) {
            throw new IllegalArgumentException("Not a valid element 'mu' for change representative for this scheme");
        }
        Zp.ZpElement psi = this.pp.getZp().getUniformlyRandomUnit();
        Zp.ZpElement psiInv = psi.inv();
        SPSEQSignature sigma = (SPSEQSignature)signature;
        GroupElement sigmaZ = sigma.getGroup1ElementSigma1Z().pow((Zn.ZnElement)psi.mul((Element)mu)).compute();
        GroupElement sigmaY = sigma.getGroup1ElementSigma2Y().pow((Zn.ZnElement)psiInv).compute();
        GroupElement sigmaHatY = sigma.getGroup1ElementSigma3HatY().pow((Zn.ZnElement)psiInv).compute();
        return new SPSEQSignature(sigmaZ, sigmaY, sigmaHatY);
    }

    @Override
    public Signature chgRepWithVerify(PlainText plainText, Signature signature, Zn.ZnElement mu, VerificationKey publicKey) {
        if (!this.verify(plainText, signature, publicKey).booleanValue()) {
            return null;
        }
        return this.chgRep(signature, mu, publicKey);
    }

    @Override
    public PlainText chgRepMessage(PlainText plainText, Zn.ZnElement mu) {
        if (plainText instanceof GroupElementPlainText) {
            plainText = new MessageBlock(plainText);
        }
        if (!(plainText instanceof MessageBlock)) {
            throw new IllegalArgumentException("Not a valid plain text for this scheme");
        }
        if (!(mu instanceof Zp.ZpElement)) {
            throw new IllegalArgumentException("Not a valid element 'mu' for change representative for this scheme");
        }
        return new MessageBlock(((MessageBlock)plainText).stream().map(m -> ((GroupElementPlainText)m).get().pow(mu).compute()).map(GroupElementPlainText::new).collect(Collectors.toList()));
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    @Override
    public MessageBlock restorePlainText(Representation repr) {
        return new MessageBlock(repr, r -> new GroupElementPlainText((Representation)r, this.pp.getBilinearMap().getG1()));
    }

    @Override
    public SPSEQSignature restoreSignature(Representation repr) {
        return new SPSEQSignature(repr, this.pp.getBilinearMap().getG1(), this.pp.getBilinearMap().getG2());
    }

    @Override
    public SPSEQSigningKey restoreSigningKey(Representation repr) {
        return new SPSEQSigningKey(repr, this.pp.getZp());
    }

    @Override
    public SPSEQVerificationKey restoreVerificationKey(Representation repr) {
        return new SPSEQVerificationKey(this.pp.getBilinearMap().getG2(), repr);
    }

    public SPSEQPublicParameters getPp() {
        return this.pp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pp == null ? 0 : this.pp.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SPSEQSignatureScheme that = (SPSEQSignatureScheme)other;
        return Objects.equals(this.pp, that.pp);
    }

    @Override
    public MessageBlock mapToPlaintext(byte[] bytes, VerificationKey pk) {
        return this.mapToPlaintext(bytes, ((SPSEQVerificationKey)pk).getNumberOfMessages());
    }

    @Override
    public MessageBlock mapToPlaintext(byte[] bytes, SigningKey sk) {
        return this.mapToPlaintext(bytes, ((SPSEQSigningKey)sk).getNumberOfMessages());
    }

    private MessageBlock mapToPlaintext(byte[] bytes, int messageBlockLength) {
        PlainText[] msgBlock = new GroupElementPlainText[messageBlockLength];
        msgBlock[0] = new GroupElementPlainText(this.pp.getGroup1ElementP().pow((Zn.ZnElement)this.pp.getZp().injectiveValueOf(bytes)));
        for (int i = 1; i < msgBlock.length; ++i) {
            msgBlock[i] = new GroupElementPlainText(this.pp.getGroup1ElementP());
        }
        return new MessageBlock(msgBlock);
    }

    @Override
    public int getMaxNumberOfBytesForMapToPlaintext() {
        return (this.pp.getBilinearMap().getG1().size().bitLength() - 1) / 8;
    }
}

