/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.enc.streaming;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.cryptimeleon.craco.common.utils.StreamUtil;
import org.cryptimeleon.craco.enc.EncryptionKeyPair;
import org.cryptimeleon.craco.enc.StreamingEncryptionScheme;
import org.cryptimeleon.craco.enc.streaming.StreamingEncryptionSchemeParams;
import org.cryptimeleon.craco.enc.streaming.params.StreamingAESParams;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StreamingEncryptionSchemeTest {
    private static SecureRandom RANDOM = new SecureRandom();
    private static int LENGTH = 18432;
    private StreamingEncryptionScheme encryptionScheme;
    private EncryptionKeyPair keyPair;

    public StreamingEncryptionSchemeTest(StreamingEncryptionSchemeParams params) {
        this.encryptionScheme = params.getEncryptionScheme();
        this.keyPair = params.getKeyPair();
    }

    @Test
    public void testDeprecatedStreamingEncryptDecrypt() {
        try {
            System.out.println("Testing the encrypt(InputStream plainIn, OutputStream cipherOut, EncryptionKey pk) for " + this.encryptionScheme.getClass().getName());
            byte[] randomBytes = new byte[LENGTH];
            RANDOM.nextBytes(randomBytes);
            ByteArrayInputStream plainIn = new ByteArrayInputStream(randomBytes);
            ByteArrayOutputStream cipherOut = new ByteArrayOutputStream();
            this.encryptionScheme.encrypt((InputStream)plainIn, (OutputStream)cipherOut, this.keyPair.getPk());
            System.out.println("Testing the decrypt(InputStream cipherIn, OutputStream plainOut, DecryptionKey sk) for " + this.encryptionScheme.getClass().getName());
            ByteArrayInputStream cipherIn = new ByteArrayInputStream(cipherOut.toByteArray());
            ByteArrayOutputStream plainOut = new ByteArrayOutputStream();
            this.encryptionScheme.decrypt((InputStream)cipherIn, (OutputStream)plainOut, this.keyPair.getSk());
            System.out.println("Asserting the results...");
            Assert.assertArrayEquals((byte[])randomBytes, (byte[])plainOut.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testEncryptInputStreamAndDecryptInputStream() {
        try {
            System.out.println("Testing the encrypt(InputStream plainIn, EncryptionKey pk) for " + this.encryptionScheme.getClass().getName());
            byte[] randomBytes = new byte[LENGTH];
            RANDOM.nextBytes(randomBytes);
            ByteArrayInputStream plainBytesIn = new ByteArrayInputStream(randomBytes);
            ByteArrayOutputStream plainBytesOut = new ByteArrayOutputStream(LENGTH);
            try (InputStream encryptedInputStream = this.encryptionScheme.encrypt((InputStream)plainBytesIn, this.keyPair.getPk());){
                System.out.println("Testing the decrypt(InputStream cipherIn, DecryptionKey sk) for " + this.encryptionScheme.getClass().getName());
                try (InputStream decryptedCiphertext = this.encryptionScheme.decrypt(encryptedInputStream, this.keyPair.getSk());){
                    StreamUtil.copy((InputStream)decryptedCiphertext, (OutputStream)plainBytesOut);
                }
            }
            System.out.println("Asserting the results...");
            Assert.assertArrayEquals((byte[])randomBytes, (byte[])plainBytesOut.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testCreateEncryptorAndCreateDecryptor() {
        try {
            System.out.println("Testing the createEncryptor(OutputStream cipherOut, EncryptionKey pk) for " + this.encryptionScheme.getClass().getName());
            byte[] randomBytes = new byte[LENGTH];
            RANDOM.nextBytes(randomBytes);
            ByteArrayOutputStream cipherOut = new ByteArrayOutputStream();
            ByteArrayOutputStream plainOut = new ByteArrayOutputStream();
            try (OutputStream encryptingOut = this.encryptionScheme.createEncryptor((OutputStream)cipherOut, this.keyPair.getPk());){
                encryptingOut.write(randomBytes);
            }
            System.out.println("Testing the createDecryptor(OutputStream plainOut, DecryptionKey sk) for " + this.encryptionScheme.getClass().getName());
            var5_6 = null;
            try (OutputStream decryptingOut = this.encryptionScheme.createDecryptor((OutputStream)plainOut, this.keyPair.getSk());){
                decryptingOut.write(cipherOut.toByteArray());
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
            System.out.println("Asserting the results...");
            Assert.assertArrayEquals((byte[])randomBytes, (byte[])plainOut.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<StreamingEncryptionSchemeParams> data() {
        ArrayList<StreamingEncryptionSchemeParams> toReturn = new ArrayList<StreamingEncryptionSchemeParams>();
        toReturn.addAll(Arrays.asList(StreamingAESParams.getParams()));
        return toReturn;
    }
}

