/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.kem;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import org.cryptimeleon.craco.common.ByteArrayImplementation;
import org.cryptimeleon.craco.enc.CipherText;
import org.cryptimeleon.craco.enc.DecryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKeyPair;
import org.cryptimeleon.craco.enc.SymmetricKey;
import org.cryptimeleon.craco.enc.asym.elgamal.ElgamalPrivateKey;
import org.cryptimeleon.craco.kem.KeyEncapsulationMechanism;
import org.cryptimeleon.craco.kem.asym.elgamal.ElgamalKEM;
import org.cryptimeleon.craco.kem.asym.elgamal.ElgamalKEMCiphertext;
import org.cryptimeleon.math.hash.HashFunction;
import org.cryptimeleon.math.hash.impl.SHA256HashFunction;
import org.cryptimeleon.math.misc.ByteArrayImpl;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.RingGroup;
import org.cryptimeleon.math.structures.rings.Ring;
import org.cryptimeleon.math.structures.rings.zn.Zp;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ElgamalKEMTest {
    static ElgamalPrivateKey sk;
    static ElgamalKEM kem;
    static HashFunction md;
    static String p;
    static String q;
    static String g;

    @BeforeClass
    public static void setup() throws NoSuchAlgorithmException {
        Zp zp = new Zp(new BigInteger(p, 16));
        RingGroup zpStar = RingGroup.unitGroupOf((Ring)zp);
        md = new SHA256HashFunction();
        kem = new ElgamalKEM((Group)zpStar, md);
        EncryptionKeyPair keypair = kem.generateKeyPair();
        sk = (ElgamalPrivateKey)keypair.getSk();
    }

    @Test
    public void testEncryption() {
        System.out.println("Generate encapsulation.");
        KeyEncapsulationMechanism.KeyAndCiphertext kAndC = kem.encaps((EncryptionKey)sk.getPublicKey());
        SymmetricKey k = (SymmetricKey)kAndC.key;
        ElgamalKEMCiphertext C = (ElgamalKEMCiphertext)kAndC.encapsulatedKey;
        Assert.assertEquals((long)md.getOutputLength(), (long)((ByteArrayImplementation)k).length());
        System.out.println("Generate new encapsultion and check that different");
        Assert.assertFalse((boolean)((SymmetricKey)ElgamalKEMTest.kem.encaps((EncryptionKey)ElgamalKEMTest.sk.getPublicKey()).key).equals(k));
        System.out.println("Check that descapsulation provides same key.");
        Assert.assertEquals((Object)k, (Object)kem.decaps((CipherText)C, (DecryptionKey)sk));
        ElgamalKEMCiphertext Cprime = new ElgamalKEMCiphertext(C.getElgamalCipherText(), C.getSymmetricEncryption().xor((ByteArrayImpl)new ByteArrayImplementation(new byte[]{1})));
        System.out.println("Check non-malleability");
        ByteArrayImplementation kprime = kem.decaps((CipherText)Cprime, (DecryptionKey)sk);
        Assert.assertTrue((boolean)kprime.equals((Object)new ByteArrayImplementation(new byte[0])));
    }

    static {
        p = "B10B8F96A080E01DDE92DE5EAE5D54EC52C99FBCFB06A3C69A6A9DCA52D23B616073E28675A23D189838EF1E2EE652C013ECB4AEA906112324975C3CD49B83BFACCBDD7D90C4BD7098488E9C219A73724EFFD6FAE5644738FAA31A4FF55BCCC0A151AF5F0DC8B4BD45BF37DF365C1A65E68CFDA76D4DA708DF1FB2BC2E4A4371";
        q = "F518AA8781A8DF278ABA4E7D64B7CB9D49462353";
        g = "A4D1CBD5C3FD34126765A442EFB99905F8104DD258AC507FD6406CFF14266D31266FEA1E5C41564B777E690F5504F213160217B4B01B886A5E91547F9E2749F4D7FBD7D3B9A92EE1909D0D2263F80A76A6A24C087A091F531DBF0A0169B6A28AD662A4D18E73AFA32D779D5918D08BC8858F4DCEF97C2A24855E6EEB22B3B2E5";
    }
}

