/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.kem;

import java.util.ArrayList;
import java.util.Collection;
import org.cryptimeleon.craco.enc.DecryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKeyPair;
import org.cryptimeleon.craco.kem.KeyEncapsulationMechanism;
import org.cryptimeleon.craco.kem.KeyEncapsulationMechanismTestParams;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class KeyEncapsulationMechanismTest {
    private KeyEncapsulationMechanism kem;
    private EncryptionKeyPair validKeyPair;
    private EncryptionKeyPair invalidKeyPair;

    public KeyEncapsulationMechanismTest(KeyEncapsulationMechanismTestParams params) {
        this.kem = params.kem;
        this.validKeyPair = params.validKeyPair;
        this.invalidKeyPair = params.invalidKeyPair;
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<KeyEncapsulationMechanismTestParams> data() {
        ArrayList<KeyEncapsulationMechanismTestParams> schemes = new ArrayList<KeyEncapsulationMechanismTestParams>();
        return schemes;
    }

    @Test
    public void testEncapsDecrypt() {
        System.out.println("Testing valid encaps/decaps for " + this.kem.getClass().getName() + " ...");
        DecryptionKey sk = this.validKeyPair.getSk();
        EncryptionKey pk = this.validKeyPair.getPk();
        KeyEncapsulationMechanism.KeyAndCiphertext keyAndCiphertext = this.kem.encaps(pk);
        Object key = this.kem.decaps(keyAndCiphertext.encapsulatedKey, sk);
        Assert.assertTrue((boolean)key.equals(keyAndCiphertext.key));
    }

    @Test
    public void testFailEncryptDecrypt() {
        System.out.println("Testing invalid encaps/decaps for " + this.kem.getClass().getName() + " ...");
        DecryptionKey sk = this.invalidKeyPair.getSk();
        EncryptionKey pk = this.invalidKeyPair.getPk();
        KeyEncapsulationMechanism.KeyAndCiphertext keyAndCiphertext = this.kem.encaps(pk);
        try {
            Object key = this.kem.decaps(keyAndCiphertext.encapsulatedKey, sk);
            Assert.assertFalse((boolean)key.equals(keyAndCiphertext.key));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }
}

