/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols;

import org.cryptimeleon.craco.protocols.CommonInput;
import org.cryptimeleon.craco.protocols.ProtocolsTest;
import org.cryptimeleon.craco.protocols.SecretInput;
import org.cryptimeleon.craco.protocols.arguments.sigma.ChallengeSpace;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocol;
import org.cryptimeleon.craco.protocols.arguments.sigma.ZnChallengeSpace;
import org.cryptimeleon.craco.protocols.arguments.sigma.partial.AndProof;
import org.cryptimeleon.craco.protocols.arguments.sigma.partial.OrProof;
import org.cryptimeleon.craco.protocols.arguments.sigma.partial.ProofOfPartialKnowledge;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.SendFirstValue;
import org.cryptimeleon.math.expressions.bool.BooleanExpression;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.Structure;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.junit.jupiter.api.Test;

public class PartialKnowledgeTest
extends ProtocolsTest {
    @Test
    public void testSimpleOr() {
        Zn.ZnElement x1 = g.getStructure().getUniformlyRandomExponent();
        GroupElement h1 = g.pow(x1);
        OrProof orProof = new OrProof(PartialKnowledgeTest.getSimpleSchnorrProof(), PartialKnowledgeTest.getSimpleSchnorrProof(h1));
        this.runTests((SigmaProtocol)orProof, (CommonInput)new CommonInput.CommonInputVector(new CommonInput[]{PartialKnowledgeTest.getSimpleSchnorrProofInput(), PartialKnowledgeTest.getSimpleSchnorrProofInput()}), (SecretInput)new OrProof.OrProofSecretInput(PartialKnowledgeTest.getSimpleSchnorrProofWitness(), false));
        this.runTests((SigmaProtocol)orProof, (CommonInput)new CommonInput.CommonInputVector(new CommonInput[]{PartialKnowledgeTest.getSimpleSchnorrProofInput(), PartialKnowledgeTest.getSimpleSchnorrProofInput()}), (SecretInput)new OrProof.OrProofSecretInput(PartialKnowledgeTest.getSimpleSchnorrProofWitness(x1), true));
    }

    @Test
    public void testSimpleAnd() {
        Zn.ZnElement x1 = g.getStructure().getUniformlyRandomExponent();
        GroupElement h1 = g.pow(x1);
        AndProof andProof = new AndProof(new SigmaProtocol[]{PartialKnowledgeTest.getSimpleSchnorrProof(), PartialKnowledgeTest.getSimpleSchnorrProof(h1)});
        this.runTests((SigmaProtocol)andProof, (CommonInput)new CommonInput.CommonInputVector(new CommonInput[]{PartialKnowledgeTest.getSimpleSchnorrProofInput(), PartialKnowledgeTest.getSimpleSchnorrProofInput()}), (SecretInput)new SecretInput.SecretInputVector(new SecretInput[]{PartialKnowledgeTest.getSimpleSchnorrProofWitness(), PartialKnowledgeTest.getSimpleSchnorrProofWitness(x1)}));
    }

    @Test
    public void testProofOfPartialKnowledge() {
        final Zn.ZnElement x1 = g.getStructure().getUniformlyRandomExponent();
        final GroupElement h1 = g.pow(x1);
        final GroupElement sendFirst = h1.pow(x1);
        ProofOfPartialKnowledge protocol = new ProofOfPartialKnowledge(){

            protected ProofOfPartialKnowledge.ProtocolTree provideProtocolTree(CommonInput commonInput, SendFirstValue sendFirstValue) {
                return this.or(this.and(this.leaf("simple", ProtocolsTest.getSimpleSchnorrProof(), ProtocolsTest.getSimpleSchnorrProofInput()), this.leaf("h1", ProtocolsTest.getSimpleSchnorrProof(h1), ProtocolsTest.getSimpleSchnorrProofInput())), this.leaf("sendFirstDlog", ProtocolsTest.getSimpleSchnorrProof(((SendFirstValue.AlgebraicSendFirstValue)sendFirstValue).getGroupElement(0)), ProtocolsTest.getSimpleSchnorrProofInput()));
            }

            protected ProofOfPartialKnowledge.ProverSpec provideProverSpec(CommonInput commonInput, SecretInput secretInput, ProofOfPartialKnowledge.ProverSpecBuilder builder) {
                builder.setSendFirstValue((SendFirstValue)new SendFirstValue.AlgebraicSendFirstValue(new Element[]{sendFirst}));
                builder.putSecretInput("sendFirstDlog", ProtocolsTest.getSimpleSchnorrProofWitness(x1.square()));
                return builder.build();
            }

            protected SendFirstValue restoreSendFirstValue(CommonInput commonInput, Representation repr) {
                return new SendFirstValue.AlgebraicSendFirstValue(repr, new Structure[]{ProtocolsTest.g.getStructure()});
            }

            protected SendFirstValue simulateSendFirstValue(CommonInput commonInput) {
                return new SendFirstValue.AlgebraicSendFirstValue(new Element[]{ProtocolsTest.g.getStructure().getUniformlyRandomElement()});
            }

            protected BooleanExpression provideAdditionalCheck(CommonInput commonInput, SendFirstValue sendFirstValue) {
                return BooleanExpression.TRUE;
            }

            public ChallengeSpace getChallengeSpace(CommonInput commonInput) {
                return new ZnChallengeSpace(ProtocolsTest.g.getStructure().getZn());
            }
        };
        this.runTests((SigmaProtocol)protocol, CommonInput.EMPTY, SecretInput.EMPTY);
    }
}

