/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.secretsharing.accessstructure.utils;

import java.math.BigInteger;
import org.cryptimeleon.craco.common.attributes.RingElementAttribute;
import org.cryptimeleon.craco.common.attributes.StringAttribute;
import org.cryptimeleon.craco.common.policies.Policy;
import org.cryptimeleon.craco.common.policies.ThresholdPolicy;
import org.cryptimeleon.craco.secretsharing.accessstructure.exceptions.WrongAccessStructureException;
import org.cryptimeleon.craco.secretsharing.accessstructure.utils.InnerNode;
import org.cryptimeleon.craco.secretsharing.accessstructure.utils.PolicyToTreeNodeConverter;
import org.cryptimeleon.craco.secretsharing.accessstructure.visitors.ToStringVisitor;
import org.cryptimeleon.craco.secretsharing.accessstructure.visitors.Visitor;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InnerNodeTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testStringAttriubteTreeRepresentation() {
        ThresholdPolicy policyA = new ThresholdPolicy(1, new Policy[]{new StringAttribute("A")});
        ThresholdPolicy policyB = new ThresholdPolicy(1, new Policy[]{new StringAttribute("B")});
        ThresholdPolicy firstPolicyStmt = new ThresholdPolicy(1, new Policy[]{policyA, policyB});
        ThresholdPolicy policyC = new ThresholdPolicy(1, new Policy[]{new StringAttribute("C")});
        ThresholdPolicy policyD = new ThresholdPolicy(1, new Policy[]{new StringAttribute("D")});
        ThresholdPolicy policyE = new ThresholdPolicy(1, new Policy[]{new StringAttribute("E")});
        ThresholdPolicy secondPolicyStmt = new ThresholdPolicy(3, new Policy[]{policyC, policyD, policyE});
        ThresholdPolicy thirdStatement = new ThresholdPolicy(1, new Policy[]{new StringAttribute("F")});
        ThresholdPolicy policy = new ThresholdPolicy(1, new Policy[]{firstPolicyStmt, secondPolicyStmt, thirdStatement});
        InnerNode root = (InnerNode)new PolicyToTreeNodeConverter((Policy)policy).getTree();
        ToStringVisitor visitor = new ToStringVisitor();
        try {
            root.performVisitor((Visitor)visitor);
            System.out.println(visitor.getResultOfCurrentNode());
        }
        catch (WrongAccessStructureException e) {
            Assert.fail((String)"Threshold Tree malformed");
        }
        Representation rootRep = policy.getRepresentation();
        InnerNode root2 = (InnerNode)new PolicyToTreeNodeConverter((Policy)new ThresholdPolicy(rootRep)).getTree();
        ToStringVisitor visitor2 = new ToStringVisitor();
        try {
            root2.performVisitor((Visitor)visitor2);
            System.out.println(visitor2.getResultOfCurrentNode());
            Assert.assertTrue((String)"", (boolean)visitor2.getResultOfCurrentNode().equals(visitor.getResultOfCurrentNode()));
        }
        catch (WrongAccessStructureException e) {
            Assert.fail((String)"Threshold Tree malformed");
        }
    }

    @Test
    public void testRingElementAttributeTreeRepresentation() {
        InnerNode firstStmt = new InnerNode();
        firstStmt.setThreshold(Integer.valueOf(1));
        Zn zn = new Zn(new BigInteger("42"));
        ThresholdPolicy policyA = new ThresholdPolicy(1, new Policy[]{new RingElementAttribute((RingElement)zn.createZnElement(new BigInteger("1")))});
        ThresholdPolicy policyB = new ThresholdPolicy(1, new Policy[]{new RingElementAttribute((RingElement)zn.createZnElement(new BigInteger("2")))});
        ThresholdPolicy firstPolicyStmt = new ThresholdPolicy(1, new Policy[]{policyA, policyB});
        ThresholdPolicy policyC = new ThresholdPolicy(1, new Policy[]{new RingElementAttribute((RingElement)zn.createZnElement(new BigInteger("3")))});
        ThresholdPolicy policyD = new ThresholdPolicy(1, new Policy[]{new RingElementAttribute((RingElement)zn.createZnElement(new BigInteger("4")))});
        ThresholdPolicy policyE = new ThresholdPolicy(1, new Policy[]{new RingElementAttribute((RingElement)zn.createZnElement(new BigInteger("5")))});
        ThresholdPolicy secondPolicyStmt = new ThresholdPolicy(3, new Policy[]{policyC, policyD, policyE});
        ThresholdPolicy thirdStatement = new ThresholdPolicy(1, new Policy[]{new RingElementAttribute((RingElement)zn.createZnElement(new BigInteger("6")))});
        ThresholdPolicy policy = new ThresholdPolicy(1, new Policy[]{firstPolicyStmt, secondPolicyStmt, thirdStatement});
        InnerNode root = (InnerNode)new PolicyToTreeNodeConverter((Policy)policy).getTree();
        ToStringVisitor visitor = new ToStringVisitor();
        try {
            root.performVisitor((Visitor)visitor);
            System.out.println(visitor.getResultOfCurrentNode());
        }
        catch (WrongAccessStructureException e) {
            Assert.fail((String)"Threshold Tree malformed");
        }
        Representation rootRep = policy.getRepresentation();
        InnerNode root2 = (InnerNode)new PolicyToTreeNodeConverter((Policy)new ThresholdPolicy(rootRep)).getTree();
        ToStringVisitor visitor2 = new ToStringVisitor();
        try {
            root2.performVisitor((Visitor)visitor2);
            System.out.println(visitor2.getResultOfCurrentNode());
            Assert.assertTrue((String)"", (boolean)visitor2.getResultOfCurrentNode().equals(visitor.getResultOfCurrentNode()));
        }
        catch (WrongAccessStructureException e) {
            Assert.fail((String)"Threshold Tree malformed");
        }
    }
}

