/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.ser.standalone.params;

import java.math.BigInteger;
import org.cryptimeleon.craco.common.ByteArrayImplementation;
import org.cryptimeleon.craco.common.attributes.Attribute;
import org.cryptimeleon.craco.common.attributes.BigIntegerAttribute;
import org.cryptimeleon.craco.common.attributes.RingElementAttribute;
import org.cryptimeleon.craco.common.attributes.SetOfAttributes;
import org.cryptimeleon.craco.common.attributes.StringAttribute;
import org.cryptimeleon.craco.common.policies.BooleanPolicy;
import org.cryptimeleon.craco.common.policies.Policy;
import org.cryptimeleon.craco.common.policies.ThresholdPolicy;
import org.cryptimeleon.craco.secretsharing.SecretSharingSchemeProvider;
import org.cryptimeleon.craco.secretsharing.ThresholdTreeSecretSharing;
import org.cryptimeleon.craco.secretsharing.shamir.ShamirSecretSharingSchemeProvider;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.standalone.StandaloneReprSubTest;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class CommonStandaloneReprTests
extends StandaloneReprSubTest {
    private final Attribute[] attributes = new Attribute[]{new StringAttribute("A"), new StringAttribute("B"), new StringAttribute("C"), new StringAttribute("D"), new StringAttribute("E")};
    private final ThresholdPolicy leftNode = new ThresholdPolicy(1, new Policy[]{this.attributes[0], this.attributes[1]});
    private final ThresholdPolicy rightNode = new ThresholdPolicy(2, new Policy[]{this.attributes[2], this.attributes[3], this.attributes[4]});
    private final ThresholdPolicy root = new ThresholdPolicy(2, new Policy[]{this.leftNode, this.rightNode});
    private final Zp zp = new Zp(BigInteger.valueOf(13L));

    public void policyTest() {
        this.test((StandaloneRepresentable)this.root);
        this.test((StandaloneRepresentable)new BooleanPolicy(BooleanPolicy.BooleanOperator.AND, new Policy[]{new StringAttribute("A"), new StringAttribute("B")}));
    }

    public void attributeTest() {
        this.test((StandaloneRepresentable)new StringAttribute("A"));
        this.test((StandaloneRepresentable)new BigIntegerAttribute(Integer.valueOf(5)));
        this.test((StandaloneRepresentable)new ByteArrayImplementation("THISISATESTSTRING".getBytes()));
        this.test((StandaloneRepresentable)new RingElementAttribute((RingElement)this.zp.getUniformlyRandomElement()));
        StringAttribute one = new StringAttribute("one");
        StringAttribute two = new StringAttribute("two");
        StringAttribute three = new StringAttribute("three");
        this.test((StandaloneRepresentable)new SetOfAttributes(new Attribute[]{one, two, three}));
    }

    public void secretSharingTest() {
        ShamirSecretSharingSchemeProvider lsssProvider = new ShamirSecretSharingSchemeProvider();
        this.test((StandaloneRepresentable)new ThresholdTreeSecretSharing(this.root, this.zp, (SecretSharingSchemeProvider)lsssProvider));
    }
}

