/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig;

import java.util.Arrays;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.serialization.Representation;
import org.junit.Assert;

public class SignatureSchemeTester {
    public static Signature testSignatureSchemeSignAndVerify(SignatureScheme signatureScheme, PlainText plainText, VerificationKey verificationKey, SigningKey signingKey) {
        Signature signature = signatureScheme.sign(plainText, signingKey);
        Assert.assertTrue((boolean)signatureScheme.verify(plainText, signature, verificationKey));
        return signature;
    }

    public static void testRepresentationSignatureScheme(SignatureScheme signatureScheme, PlainText plainText, VerificationKey verificationKey, SigningKey signingKey) {
        Signature signature = signatureScheme.sign(plainText, signingKey);
        Representation signatureRepresentation = signature.getRepresentation();
        Signature signatureFromRepr = signatureScheme.restoreSignature(signatureRepresentation);
        Assert.assertEquals((Object)signature, (Object)signatureFromRepr);
        Representation signingKeyRepresentation = signingKey.getRepresentation();
        SigningKey signingKeyFromRepr = signatureScheme.restoreSigningKey(signingKeyRepresentation);
        Assert.assertEquals((Object)signingKey, (Object)signingKeyFromRepr);
        Representation verificationKeyRepresentation = verificationKey.getRepresentation();
        VerificationKey verificationKeyFromRepr = signatureScheme.restoreVerificationKey(verificationKeyRepresentation);
        Assert.assertEquals((Object)verificationKey, (Object)verificationKeyFromRepr);
        Representation plainTextRepresentation = plainText.getRepresentation();
        PlainText plainTextFromRepr = signatureScheme.restorePlainText(plainTextRepresentation);
        Assert.assertEquals((Object)plainText, (Object)plainTextFromRepr);
    }

    public static void testNegativeWrongMessageSignatureSchemeSignAndVerify(SignatureScheme signatureScheme, PlainText plainText, PlainText wrongPlainText, VerificationKey verificationKey, SigningKey signingKey) {
        Signature signature = signatureScheme.sign(plainText, signingKey);
        Assert.assertFalse((boolean)signatureScheme.verify(wrongPlainText, signature, verificationKey));
    }

    public static void testNegativeWrongKeysSignatureSchemeSignAndVerify(SignatureScheme signatureScheme, PlainText plainText, VerificationKey verificationKey, SigningKey signingKey, VerificationKey wrongVerificationKey, SigningKey wrongSigningKey) {
        Signature signature = signatureScheme.sign(plainText, signingKey);
        Assert.assertFalse((boolean)signatureScheme.verify(plainText, signature, wrongVerificationKey));
        Signature wrongSignature = signatureScheme.sign(plainText, wrongSigningKey);
        Assert.assertFalse((boolean)signatureScheme.verify(plainText, wrongSignature, verificationKey));
    }

    public static void testMapToPlaintext(SignatureScheme sig, VerificationKey pk) {
        byte[] randomBytes2;
        byte[] randomBytes1 = RandomGenerator.getRandomBytes((int)sig.getMaxNumberOfBytesForMapToPlaintext());
        while (Arrays.equals(randomBytes1, randomBytes2 = RandomGenerator.getRandomBytes((int)sig.getMaxNumberOfBytesForMapToPlaintext()))) {
        }
        Assert.assertNotEquals((Object)sig.mapToPlaintext(randomBytes1, pk), (Object)sig.mapToPlaintext(randomBytes2, pk));
    }

    public static void testMapToPlainTextContract(SignatureScheme sig, SignatureKeyPair keyPair) {
        byte[] randomBytes = RandomGenerator.getRandomBytes((int)sig.getMaxNumberOfBytesForMapToPlaintext());
        Assert.assertEquals((Object)sig.mapToPlaintext(randomBytes, keyPair.getVerificationKey()), (Object)sig.mapToPlaintext(randomBytes, keyPair.getSigningKey()));
    }
}

