/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.hashthensign;

import java.util.ArrayList;
import java.util.Collection;
import org.cryptimeleon.craco.common.ByteArrayImplementation;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SignatureSchemeTester;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.hashthensign.HashThenSign;
import org.cryptimeleon.craco.sig.hashthensign.params.BBSHTSParams;
import org.cryptimeleon.craco.sig.hashthensign.params.HashThenSignParams;
import org.cryptimeleon.craco.sig.hashthensign.params.PSHTSParams;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HashThenSignTest {
    private SignatureScheme hashThenSign;
    private SignatureKeyPair<? extends VerificationKey, ? extends SigningKey> keyPair1;
    private SignatureKeyPair<? extends VerificationKey, ? extends SigningKey> keyPair2;
    private ByteArrayImplementation message1;
    private ByteArrayImplementation message2;

    public HashThenSignTest(HashThenSignParams params) {
        this.hashThenSign = new HashThenSign(params.getHashFunction(), params.getSignatureScheme());
        this.keyPair1 = params.getKeyPair1();
        this.keyPair2 = params.getKeyPair2();
        this.message1 = (ByteArrayImplementation)params.getMessage1();
        this.message2 = (ByteArrayImplementation)params.getMessage2();
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<HashThenSignParams> data() {
        ArrayList<HashThenSignParams> schemesToTest = new ArrayList<HashThenSignParams>();
        schemesToTest.addAll(PSHTSParams.getParams());
        schemesToTest.addAll(BBSHTSParams.getParams());
        return schemesToTest;
    }

    @Test
    public void testSignAndVerify() {
        SignatureSchemeTester.testSignatureSchemeSignAndVerify(this.hashThenSign, (PlainText)this.message1, this.keyPair1.getVerificationKey(), this.keyPair1.getSigningKey());
    }

    @Test
    public void testNegativeSignAndVerifyWrongMesssage() {
        SignatureSchemeTester.testNegativeWrongMessageSignatureSchemeSignAndVerify(this.hashThenSign, (PlainText)this.message1, (PlainText)this.message2, this.keyPair1.getVerificationKey(), this.keyPair1.getSigningKey());
    }

    @Test
    public void testNegativeSignAndVerifyWrongKeys() {
        SignatureSchemeTester.testNegativeWrongKeysSignatureSchemeSignAndVerify(this.hashThenSign, (PlainText)this.message1, this.keyPair1.getVerificationKey(), this.keyPair1.getSigningKey(), this.keyPair2.getVerificationKey(), this.keyPair2.getSigningKey());
    }

    @Test
    public void testRepresentations() {
        SignatureSchemeTester.testRepresentationSignatureScheme(this.hashThenSign, (PlainText)this.message1, this.keyPair1.getVerificationKey(), this.keyPair1.getSigningKey());
    }
}

