/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.eq;

import java.util.stream.Collectors;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SignatureSchemeParams;
import org.cryptimeleon.craco.sig.SignatureSchemeTester;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.sps.eq.SPSEQPublicParameters;
import org.cryptimeleon.craco.sig.sps.eq.SPSEQSignature;
import org.cryptimeleon.craco.sig.sps.eq.SPSEQSignatureScheme;
import org.cryptimeleon.craco.sig.sps.eq.SPSEQSignatureSchemeTestParamGenerator;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SPSEQSignatureSchemeTest {
    static long timerStart = 0L;
    static int testIterations = 1;
    private final int NUM_MESSAGES = 2;
    private final int SECURITY_PARAMETER = 128;
    private SPSEQSignatureScheme spseqScheme;
    private SignatureKeyPair<? extends VerificationKey, ? extends SigningKey> keyPair;
    private SignatureKeyPair<? extends VerificationKey, ? extends SigningKey> wrongKeyPair;
    private SPSEQPublicParameters pp;
    private MessageBlock messageBlock;
    private MessageBlock wrongMessageBlock;

    @Before
    public void setUp() throws Exception {
        for (int i = 0; i < 1; ++i) {
            SignatureSchemeParams params = SPSEQSignatureSchemeTestParamGenerator.generateParams(128, 2);
            this.spseqScheme = (SPSEQSignatureScheme)params.getSignatureScheme();
            this.keyPair = params.getKeyPair1();
            this.wrongKeyPair = params.getKeyPair2();
            this.pp = (SPSEQPublicParameters)params.getPublicParameters();
            this.messageBlock = (MessageBlock)params.getMessage1();
            this.wrongMessageBlock = (MessageBlock)params.getMessage2();
        }
    }

    @Test
    public void testSPSEQSignatureSchemeSignAndVerify() {
        for (int i = 0; i < testIterations; ++i) {
            SignatureSchemeTester.testSignatureSchemeSignAndVerify((SignatureScheme)this.spseqScheme, (PlainText)this.messageBlock, this.keyPair.getVerificationKey(), this.keyPair.getSigningKey());
        }
    }

    @Test
    public void testSPSEQSignatureSchemeChgRep() {
        for (int i = 0; i < testIterations; ++i) {
            SPSEQSignature sigma = (SPSEQSignature)SignatureSchemeTester.testSignatureSchemeSignAndVerify((SignatureScheme)this.spseqScheme, (PlainText)this.messageBlock, this.keyPair.getVerificationKey(), this.keyPair.getSigningKey());
            Zp.ZpElement mu = this.pp.getZp().getUniformlyRandomUnit();
            SPSEQSignatureSchemeTest.measureTime(null);
            SPSEQSignature sigmaChgRep = (SPSEQSignature)this.spseqScheme.chgRep((Signature)sigma, (Zn.ZnElement)mu, this.keyPair.getVerificationKey());
            SPSEQSignatureSchemeTest.measureTime("ChgRep");
            MessageBlock msgChgRep = new MessageBlock(this.messageBlock.stream().map(m -> ((GroupElementPlainText)m).get().pow((Zn.ZnElement)mu)).map(GroupElementPlainText::new).collect(Collectors.toList()));
            Assert.assertTrue((boolean)this.spseqScheme.verify((PlainText)msgChgRep, (Signature)sigmaChgRep, this.keyPair.getVerificationKey()));
            sigmaChgRep = (SPSEQSignature)this.spseqScheme.chgRepWithVerify((PlainText)this.messageBlock, (Signature)sigma, (Zn.ZnElement)mu, this.keyPair.getVerificationKey());
            PlainText msgChgRepMessage = this.spseqScheme.chgRepMessage((PlainText)this.messageBlock, (Zn.ZnElement)mu);
            Assert.assertTrue((boolean)this.spseqScheme.verify(msgChgRepMessage, (Signature)sigmaChgRep, this.keyPair.getVerificationKey()));
            Assert.assertTrue((boolean)msgChgRep.equals((Object)msgChgRepMessage));
        }
    }

    @Test
    public void testSPSEQSignatureSchemeRepresentationText() {
        SignatureSchemeTester.testRepresentationSignatureScheme((SignatureScheme)this.spseqScheme, (PlainText)this.messageBlock, this.keyPair.getVerificationKey(), this.keyPair.getSigningKey());
        SPSEQPublicParameters ppTest = new SPSEQPublicParameters(this.pp.getRepresentation());
        Assert.assertEquals((Object)this.pp, (Object)ppTest);
    }

    @Test
    public void testMapToPlaintext() {
        SignatureSchemeTester.testMapToPlaintext((SignatureScheme)this.spseqScheme, this.keyPair.getVerificationKey());
    }

    @Test
    public void testMapToPlaintextContract() {
        SignatureSchemeTester.testMapToPlainTextContract((SignatureScheme)this.spseqScheme, this.keyPair);
    }

    protected static void measureTime(String str) {
        if (timerStart == 0L) {
            timerStart = System.currentTimeMillis();
        } else {
            long end = System.currentTimeMillis();
            System.out.println(str + ": " + (end - timerStart) / 1000L + "s, " + (end - timerStart) % 1000L + "ms");
            timerStart = 0L;
        }
    }
}

