/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.common.policies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.cryptimeleon.craco.common.policies.Policy;
import org.cryptimeleon.craco.common.policies.PolicyFact;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.annotations.AnnotatedUbrUtil;
import org.cryptimeleon.math.hash.annotations.UniqueByteRepresented;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;

public class ThresholdPolicy
implements Policy {
    @UniqueByteRepresented
    @Represented
    private Integer threshold;
    @UniqueByteRepresented
    @Represented
    private ArrayList<Policy> children;

    public ThresholdPolicy(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    public ThresholdPolicy(int threshold, Collection<? extends Policy> children) {
        this.threshold = threshold;
        this.children = new ArrayList();
        this.children.addAll(children);
    }

    public ThresholdPolicy(int threshold, Policy ... children) {
        this(threshold, Arrays.asList(children));
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    @Override
    public boolean isFulfilled(Collection<? extends PolicyFact> facts) {
        int fulfilled = 0;
        for (Policy policy : this.children) {
            fulfilled += policy.isFulfilled(facts) ? 1 : 0;
        }
        return fulfilled >= this.threshold;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public ArrayList<Policy> getChildren() {
        return new ArrayList<Policy>(this.children);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + this.threshold;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThresholdPolicy other = (ThresholdPolicy)obj;
        if (this.children == null) {
            if (other.children != null) {
                return false;
            }
        } else {
            if (!this.children.containsAll(other.children)) {
                return false;
            }
            if (!other.children.containsAll(this.children)) {
                return false;
            }
        }
        return this.threshold.equals(other.threshold);
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        return AnnotatedUbrUtil.autoAccumulate((ByteAccumulator)accumulator, (Object)this);
    }
}

