/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma.schnorr;

import org.cryptimeleon.craco.protocols.CommonInput;
import org.cryptimeleon.craco.protocols.SecretInput;
import org.cryptimeleon.craco.protocols.arguments.sigma.Announcement;
import org.cryptimeleon.craco.protocols.arguments.sigma.AnnouncementSecret;
import org.cryptimeleon.craco.protocols.arguments.sigma.Challenge;
import org.cryptimeleon.craco.protocols.arguments.sigma.Response;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocol;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocolTranscript;
import org.cryptimeleon.craco.protocols.arguments.sigma.ZnChallenge;
import org.cryptimeleon.craco.protocols.arguments.sigma.ZnChallengeSpace;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.SchnorrFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.SendFirstValue;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.SendThenDelegateFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariableAssignment;
import org.cryptimeleon.math.expressions.bool.BooleanExpression;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.serialization.Representation;

public abstract class SendThenDelegateProtocol
implements SigmaProtocol {
    protected abstract SendThenDelegateFragment.ProverSpec provideProverSpec(CommonInput var1, SecretInput var2, SendThenDelegateFragment.ProverSpecBuilder var3);

    protected abstract SendFirstValue restoreSendFirstValue(CommonInput var1, Representation var2);

    protected abstract SendFirstValue simulateSendFirstValue(CommonInput var1);

    protected abstract SendThenDelegateFragment.SubprotocolSpec provideSubprotocolSpec(CommonInput var1, SendFirstValue var2, SendThenDelegateFragment.SubprotocolSpecBuilder var3);

    protected abstract BooleanExpression provideAdditionalCheck(CommonInput var1, SendFirstValue var2);

    @Override
    public abstract ZnChallengeSpace getChallengeSpace(CommonInput var1);

    @Override
    public AnnouncementSecret generateAnnouncementSecret(CommonInput commonInput, SecretInput secretInput) {
        TopLevelSchnorrFragment fragment = new TopLevelSchnorrFragment(commonInput, secretInput);
        AnnouncementSecret fragmentAnnouncementSecret = fragment.generateAnnouncementSecret(SchnorrVariableAssignment.EMPTY);
        return new SchnorrAnnouncementSecret(fragment, fragmentAnnouncementSecret);
    }

    @Override
    public Announcement generateAnnouncement(CommonInput commonInput, SecretInput secretInput, AnnouncementSecret announcementSecret) {
        SchnorrAnnouncementSecret announcementSecret1 = (SchnorrAnnouncementSecret)announcementSecret;
        return new SchnorrAnnouncement(announcementSecret1.fragment, announcementSecret1.fragment.generateAnnouncement(SchnorrVariableAssignment.EMPTY, announcementSecret1.fragmentAnnouncementSecret, SchnorrVariableAssignment.EMPTY));
    }

    @Override
    public Response generateResponse(CommonInput commonInput, SecretInput secretInput, Announcement announcement, AnnouncementSecret announcementSecret, Challenge challenge) {
        SchnorrAnnouncementSecret announcementSecret1 = (SchnorrAnnouncementSecret)announcementSecret;
        return announcementSecret1.fragment.generateResponse(SchnorrVariableAssignment.EMPTY, announcementSecret1.fragmentAnnouncementSecret, (ZnChallenge)challenge);
    }

    @Override
    public BooleanExpression checkTranscriptAsExpression(CommonInput commonInput, Announcement announcement, Challenge challenge, Response response) {
        return ((SchnorrAnnouncement)announcement).fragment.checkTranscript(((SchnorrAnnouncement)announcement).fragmentAnnouncement, (ZnChallenge)challenge, response, SchnorrVariableAssignment.EMPTY);
    }

    @Override
    public SigmaProtocolTranscript generateSimulatedTranscript(CommonInput commonInput, Challenge challenge) {
        TopLevelSchnorrFragment fragment = new TopLevelSchnorrFragment(commonInput);
        return fragment.generateSimulatedTranscript((ZnChallenge)challenge, SchnorrVariableAssignment.EMPTY);
    }

    @Override
    public Announcement restoreAnnouncement(CommonInput commonInput, Representation repr) {
        TopLevelSchnorrFragment fragment = new TopLevelSchnorrFragment(commonInput);
        return new SchnorrAnnouncement(fragment, fragment.restoreAnnouncement(repr));
    }

    @Override
    public ZnChallenge restoreChallenge(CommonInput commonInput, Representation repr) {
        return this.getChallengeSpace(commonInput).restoreChallenge(repr);
    }

    @Override
    public Response restoreResponse(CommonInput commonInput, Announcement announcement, Challenge challenge, Representation repr) {
        return ((SchnorrAnnouncement)announcement).fragment.restoreResponse(((SchnorrAnnouncement)announcement).fragmentAnnouncement, repr);
    }

    @Override
    public Representation compressTranscript(CommonInput commonInput, SigmaProtocolTranscript transcript) {
        SchnorrAnnouncement announcement = (SchnorrAnnouncement)transcript.getAnnouncement();
        return announcement.fragment.compressTranscript(announcement.fragmentAnnouncement, (ZnChallenge)transcript.getChallenge(), transcript.getResponse(), SchnorrVariableAssignment.EMPTY);
    }

    @Override
    public SigmaProtocolTranscript decompressTranscript(CommonInput commonInput, Challenge challenge, Representation compressedTranscript) throws IllegalArgumentException {
        TopLevelSchnorrFragment fragment = new TopLevelSchnorrFragment(commonInput);
        SigmaProtocolTranscript fragmentTranscript = fragment.decompressTranscript(compressedTranscript, (ZnChallenge)challenge, SchnorrVariableAssignment.EMPTY);
        return new SigmaProtocolTranscript(new SchnorrAnnouncement(fragment, fragmentTranscript.getAnnouncement()), challenge, fragmentTranscript.getResponse());
    }

    @Override
    public void debugProof(CommonInput commonInput, SecretInput secretInput) {
        new TopLevelSchnorrFragment(commonInput, secretInput).debugFragment(SchnorrVariableAssignment.EMPTY, this.getChallengeSpace(commonInput));
    }

    private class TopLevelSchnorrFragment
    extends SendThenDelegateFragment {
        public final CommonInput commonInput;
        public final SecretInput secretInput;

        public TopLevelSchnorrFragment(CommonInput commonInput, SecretInput secretInput) {
            this.commonInput = commonInput;
            this.secretInput = secretInput;
        }

        public TopLevelSchnorrFragment(CommonInput commonInput) {
            this(commonInput, null);
        }

        @Override
        protected SendThenDelegateFragment.ProverSpec provideProverSpec(SchnorrVariableAssignment externalWitnesses, SendThenDelegateFragment.ProverSpecBuilder builder) {
            return SendThenDelegateProtocol.this.provideProverSpec(this.commonInput, this.secretInput, builder);
        }

        @Override
        protected SendFirstValue restoreSendFirstValue(Representation repr) {
            return SendThenDelegateProtocol.this.restoreSendFirstValue(this.commonInput, repr);
        }

        @Override
        protected SendFirstValue simulateSendFirstValue() {
            return SendThenDelegateProtocol.this.simulateSendFirstValue(this.commonInput);
        }

        @Override
        protected SendThenDelegateFragment.SubprotocolSpec provideSubprotocolSpec(SendFirstValue sendFirstValue, SendThenDelegateFragment.SubprotocolSpecBuilder builder) {
            return SendThenDelegateProtocol.this.provideSubprotocolSpec(this.commonInput, sendFirstValue, builder);
        }

        @Override
        protected BooleanExpression provideAdditionalCheck(SendFirstValue sendFirstValue) {
            return SendThenDelegateProtocol.this.provideAdditionalCheck(this.commonInput, sendFirstValue);
        }
    }

    private static class SchnorrAnnouncement
    implements Announcement {
        public final SchnorrFragment fragment;
        public final Announcement fragmentAnnouncement;

        public SchnorrAnnouncement(SchnorrFragment fragment, Announcement fragmentAnnouncement) {
            this.fragment = fragment;
            this.fragmentAnnouncement = fragmentAnnouncement;
        }

        public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
            return this.fragmentAnnouncement.updateAccumulator(accumulator);
        }

        public Representation getRepresentation() {
            return this.fragmentAnnouncement.getRepresentation();
        }
    }

    private static class SchnorrAnnouncementSecret
    implements AnnouncementSecret {
        public final TopLevelSchnorrFragment fragment;
        public final AnnouncementSecret fragmentAnnouncementSecret;

        public SchnorrAnnouncementSecret(TopLevelSchnorrFragment fragment, AnnouncementSecret fragmentAnnouncementSecret) {
            this.fragment = fragment;
            this.fragmentAnnouncementSecret = fragmentAnnouncementSecret;
        }
    }
}

