/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.secretsharing.accessstructure.visitors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.cryptimeleon.craco.secretsharing.accessstructure.exceptions.WrongAccessStructureException;
import org.cryptimeleon.craco.secretsharing.accessstructure.utils.ComparablePair;
import org.cryptimeleon.craco.secretsharing.accessstructure.utils.LeafNode;
import org.cryptimeleon.craco.secretsharing.accessstructure.utils.TreeNode;
import org.cryptimeleon.craco.secretsharing.accessstructure.visitors.Visitor;

public class MinimalFulfillingSubsetVisitor
implements Visitor<ComparablePair<Integer, ArrayList<Integer>>> {
    private final Set<Integer> setOfShares;
    private int threshold;
    private int numberOfFulfilledChildren = 0;
    private final ArrayList<ComparablePair<Integer, ArrayList<Integer>>> fulfilledChildrenInfo;
    private boolean fulfilled = false;
    private boolean leaf = false;
    private int leafNumber;

    public MinimalFulfillingSubsetVisitor(Set<Integer> setOfShareIdentifers) {
        this.setOfShares = setOfShareIdentifers;
        this.fulfilledChildrenInfo = new ArrayList();
    }

    @Override
    public ComparablePair<Integer, ArrayList<Integer>> getResultOfCurrentNode() {
        if (this.fulfilled) {
            ArrayList<Integer> arraylist = new ArrayList<Integer>();
            int minimalNumberOfFulfilledLeafs = 0;
            if (this.leaf) {
                arraylist.add(this.leafNumber);
                minimalNumberOfFulfilledLeafs = 1;
            } else {
                Integer counter = 0;
                Collections.sort(this.fulfilledChildrenInfo);
                for (ComparablePair<Integer, ArrayList<Integer>> entry : this.fulfilledChildrenInfo) {
                    Integer n = counter;
                    Integer n2 = counter = Integer.valueOf(counter + 1);
                    minimalNumberOfFulfilledLeafs += entry.getFirst().intValue();
                    arraylist.addAll((Collection)entry.getSecond());
                    if (!counter.equals(this.threshold)) continue;
                    break;
                }
            }
            return new ComparablePair<Integer, ArrayList<Integer>>(minimalNumberOfFulfilledLeafs, arraylist);
        }
        return new ComparablePair<Integer, Object>(0, null);
    }

    public MinimalFulfillingSubsetVisitor getVisitorForNextChild() {
        return new MinimalFulfillingSubsetVisitor(this.setOfShares);
    }

    @Override
    public void putResultOfChild(ComparablePair<Integer, ArrayList<Integer>> result) {
        if (result.getFirst() != 0) {
            ++this.numberOfFulfilledChildren;
            if (this.numberOfFulfilledChildren == this.threshold) {
                this.fulfilled = true;
            }
            this.fulfilledChildrenInfo.add(result);
        }
    }

    @Override
    public void visit(TreeNode currentNode) throws WrongAccessStructureException {
        this.threshold = currentNode.getThreshold();
        if (this.threshold == 0) {
            if (currentNode instanceof LeafNode) {
                if (this.setOfShares.contains(((LeafNode)currentNode).getShareIdentifier())) {
                    this.leafNumber = ((LeafNode)currentNode).getShareIdentifier();
                    this.fulfilled = true;
                    this.leaf = true;
                }
            } else {
                throw new WrongAccessStructureException("Tree contains a node with children and Threshold 0. \n 0 is not a valid threshold.");
            }
        }
    }
}

