/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.bbs;

import java.util.Arrays;
import java.util.Objects;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class BBSBSigningKey
implements SigningKey {
    @Represented(restorer="Zp")
    private Zp.ZpElement exponentGamma;
    @Represented(restorer="[Zp]")
    private Zp.ZpElement[] ziExponents;

    public BBSBSigningKey() {
    }

    public BBSBSigningKey(Representation repr, Zp zp) {
        new ReprUtil((Object)this).register((RepresentationRestorer)zp, "Zp").deserialize(repr);
    }

    public Zp.ZpElement getExponentGamma() {
        return this.exponentGamma;
    }

    public void setExponentGamma(Zp.ZpElement exponentGamma) {
        this.exponentGamma = exponentGamma;
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public Zp.ZpElement[] getZiExponents() {
        return this.ziExponents;
    }

    public void setZiExponents(Zp.ZpElement[] ziExponents) {
        this.ziExponents = ziExponents;
    }

    public int getNumberOfMessages() {
        return this.ziExponents.length - 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.exponentGamma == null ? 0 : this.exponentGamma.hashCode());
        result = 31 * result + Arrays.hashCode(this.ziExponents);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BBSBSigningKey other = (BBSBSigningKey)obj;
        return Objects.equals(this.exponentGamma, other.exponentGamma) && Arrays.equals(this.ziExponents, other.ziExponents);
    }
}

