/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.ps;

import java.util.Objects;
import org.cryptimeleon.craco.common.PublicParameters;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class PSPublicParameters
implements PublicParameters {
    @Represented
    private BilinearGroup bilinearGroup;
    @Represented
    private Zp zp;

    public PSPublicParameters(BilinearGroup bilinearGroup) {
        this.bilinearGroup = bilinearGroup;
        this.zp = new Zp(bilinearGroup.getG1().size());
    }

    public PSPublicParameters(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public Zp getZp() {
        return this.zp;
    }

    public BilinearMap getBilinearMap() {
        return this.bilinearGroup.getBilinearMap();
    }

    public BilinearGroup getBilinearGroup() {
        return this.bilinearGroup;
    }

    public int hashCode() {
        return Objects.hash(this.bilinearGroup);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PSPublicParameters that = (PSPublicParameters)other;
        return Objects.equals(this.bilinearGroup, that.bilinearGroup);
    }
}

