/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.groth15;

import java.util.Objects;
import org.cryptimeleon.craco.common.PublicParameters;
import org.cryptimeleon.craco.sig.sps.groth15.SPSGroth15PublicParametersGen;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.cartesian.GroupElementVector;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class SPSGroth15PublicParameters
implements PublicParameters {
    @Represented
    protected SPSGroth15PublicParametersGen.Groth15Type type;
    @Represented
    private BilinearGroup bilinearGroup;
    @Represented(restorer="bilinearGroup::getG1")
    protected GroupElement group1ElementG;
    @Represented(restorer="bilinearGroup::getG2")
    protected GroupElement group2ElementHatG;
    @Represented(restorer="plaintextGroup")
    protected GroupElementVector groupElementsYi;

    public SPSGroth15PublicParameters(BilinearGroup bilinearGroup, SPSGroth15PublicParametersGen.Groth15Type type, int numberOfMessages) {
        this.bilinearGroup = bilinearGroup;
        this.group1ElementG = this.bilinearGroup.getG1().getUniformlyRandomNonNeutral();
        this.group2ElementHatG = this.bilinearGroup.getG2().getUniformlyRandomNonNeutral();
        this.type = type;
        GroupElement plaintextGroupElement = this.getPlaintextGroupGenerator();
        this.groupElementsYi = plaintextGroupElement.getStructure().getUniformlyRandomElements(numberOfMessages);
        this.precompute();
    }

    public SPSGroth15PublicParameters(Representation repr) {
        new ReprUtil((Object)this).register(r -> this.type == SPSGroth15PublicParametersGen.Groth15Type.type1 ? this.bilinearGroup.getG1().restoreVector(r) : this.bilinearGroup.getG2().restoreVector(r), "plaintextGroup").deserialize(repr);
        this.precompute();
    }

    private void precompute() {
        this.group1ElementG.precomputePow();
        this.group2ElementHatG.precomputePow();
        this.groupElementsYi.precomputePow();
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public Zp getZp() {
        return new Zp(this.bilinearGroup.getG1().size());
    }

    public BilinearMap getBilinearMap() {
        return this.bilinearGroup.getBilinearMap();
    }

    public GroupElementVector getGroupElementsYi() {
        return this.groupElementsYi;
    }

    public GroupElement getPlaintextGroupGenerator() {
        if (this.type == SPSGroth15PublicParametersGen.Groth15Type.type1) {
            return this.group1ElementG;
        }
        return this.group2ElementHatG;
    }

    public GroupElement getOtherGroupGenerator() {
        if (this.type == SPSGroth15PublicParametersGen.Groth15Type.type1) {
            return this.group2ElementHatG;
        }
        return this.group1ElementG;
    }

    public int getNumberOfMessages() {
        return this.groupElementsYi.length();
    }

    public int hashCode() {
        return Objects.hash(this.groupElementsYi, this.bilinearGroup);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SPSGroth15PublicParameters that = (SPSGroth15PublicParameters)other;
        return Objects.equals(this.bilinearGroup, that.bilinearGroup) && Objects.equals(this.group1ElementG, that.group1ElementG) && Objects.equals(this.group2ElementHatG, that.group2ElementHatG) && Objects.equals(this.groupElementsYi, that.groupElementsYi);
    }
}

