/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.accumulator;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import org.cryptimeleon.craco.accumulator.AccumulatorDigest;
import org.cryptimeleon.craco.accumulator.AccumulatorWitness;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;

public interface AccumulatorScheme<AccumulatedType extends Representable>
extends StandaloneRepresentable,
RepresentationRestorer {
    public AccumulatorDigest createDigest(Collection<? extends AccumulatedType> var1);

    public AccumulatorWitness createWitness(AccumulatorDigest var1, Collection<? extends AccumulatedType> var2, AccumulatedType var3);

    public boolean verify(AccumulatorDigest var1, AccumulatedType var2, AccumulatorWitness var3);

    default public AccumulatorDigest insert(AccumulatorDigest digest, Collection<? extends AccumulatedType> setOfValues, AccumulatedType additionalValue) {
        HashSet<AccumulatedType> newValues = new HashSet<AccumulatedType>(setOfValues);
        newValues.add(additionalValue);
        return this.createDigest(newValues);
    }

    default public AccumulatorDigest delete(AccumulatorDigest digest, Collection<? extends AccumulatedType> setOfValues, AccumulatedType valueToDelete) {
        HashSet<AccumulatedType> newValues = new HashSet<AccumulatedType>(setOfValues);
        newValues.remove(valueToDelete);
        return this.createDigest(newValues);
    }

    default public AccumulatorWitness updateWitness(AccumulatorDigest oldDigest, AccumulatorDigest newDigest, Collection<? extends AccumulatedType> oldAccumulatedSet, Collection<? extends AccumulatedType> newAccumulatedSet, AccumulatedType valueToComputeWitnessFor, AccumulatorWitness oldWitnessToBeUpdated) {
        return this.createWitness(newDigest, newAccumulatedSet, valueToComputeWitnessFor);
    }

    public Integer getMaxNumAccumulatedValues();

    public AccumulatorWitness restoreWitness(Representation var1);

    public AccumulatorDigest restoreDigest(Representation var1);

    public AccumulatedType restoreAccumulatedValue(Representation var1);

    default public Object restoreFromRepresentation(Type type, Representation repr) throws IllegalArgumentException {
        if (type instanceof Class && AccumulatorWitness.class.isAssignableFrom((Class)type)) {
            return this.restoreWitness(repr);
        }
        if (type instanceof Class && AccumulatorDigest.class.isAssignableFrom((Class)type)) {
            return this.restoreDigest(repr);
        }
        throw new IllegalArgumentException("Group cannot restore type " + type.getTypeName() + " from representation");
    }
}

