/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.enc.asym.elgamal;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.enc.AsymmetricEncryptionScheme;
import org.cryptimeleon.craco.enc.CipherText;
import org.cryptimeleon.craco.enc.DecryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKeyPair;
import org.cryptimeleon.craco.enc.asym.elgamal.ElgamalCipherText;
import org.cryptimeleon.craco.enc.asym.elgamal.ElgamalPrivateKey;
import org.cryptimeleon.craco.enc.asym.elgamal.ElgamalPublicKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class ElgamalEncryption
implements AsymmetricEncryptionScheme {
    @Represented
    Group groupG;

    public ElgamalEncryption(Group groupG) {
        this.groupG = groupG;
    }

    public ElgamalEncryption(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    public Group getGroup() {
        return this.groupG;
    }

    @Override
    public CipherText encrypt(PlainText plainText, EncryptionKey publicKey) {
        BigInteger sizeG = this.groupG.size();
        Zn zn_random = new Zn(sizeG);
        Zn.ZnElement random_zn_element = zn_random.getUniformlyRandomElement();
        return this.encrypt(plainText, publicKey, random_zn_element.asInteger());
    }

    public CipherText encrypt(PlainText plainText, EncryptionKey publicKey, BigInteger random) {
        if (publicKey == null || plainText == null) {
            throw new IllegalArgumentException("The arguments must not be null.");
        }
        if (!(publicKey instanceof ElgamalPublicKey)) {
            throw new IllegalArgumentException("The specified public key is invalid.");
        }
        if (!(plainText instanceof GroupElementPlainText)) {
            throw new IllegalArgumentException("The specified plaintext is invalid.");
        }
        GroupElement groupElementPlaintext = ((GroupElementPlainText)plainText).get();
        GroupElement g = ((ElgamalPublicKey)publicKey).getG();
        GroupElement h = ((ElgamalPublicKey)publicKey).getH();
        GroupElement c1 = g.pow(random);
        GroupElement c2 = h.pow(random).op((Element)groupElementPlaintext);
        return new ElgamalCipherText(c1.compute(), c2.compute());
    }

    @Override
    public PlainText decrypt(CipherText cipherText, DecryptionKey privateKey) {
        if (privateKey == null || cipherText == null) {
            throw new IllegalArgumentException("The arguments must not be null.");
        }
        if (!(cipherText instanceof ElgamalCipherText)) {
            throw new IllegalArgumentException("The specified ciphertext is invalid.");
        }
        if (!(privateKey instanceof ElgamalPrivateKey)) {
            throw new IllegalArgumentException("The specified private key is invalid.");
        }
        ElgamalCipherText cpCipherText = (ElgamalCipherText)cipherText;
        Zn.ZnElement a = ((ElgamalPrivateKey)privateKey).getA();
        GroupElement u = cpCipherText.getC1().pow(a);
        GroupElement m = u.inv().op((Element)cpCipherText.getC2());
        return new GroupElementPlainText(m.compute());
    }

    @Override
    public EncryptionKeyPair generateKeyPair() {
        BigInteger sizeG = this.groupG.size();
        Zn zn_random = new Zn(sizeG);
        Zn.ZnElement a = zn_random.getUniformlyRandomElement();
        GroupElement generator = this.groupG.getUniformlyRandomNonNeutral();
        GroupElement h = generator.pow(a).compute();
        ElgamalPrivateKey privateKey = new ElgamalPrivateKey(this.groupG, generator, a, h);
        ElgamalPublicKey publicKey = privateKey.getPublicKey();
        return new EncryptionKeyPair(publicKey, privateKey);
    }

    @Override
    public PlainText restorePlainText(Representation repr) {
        return new GroupElementPlainText(repr, this.groupG);
    }

    @Override
    public ElgamalCipherText restoreCipherText(Representation repr) {
        return new ElgamalCipherText(repr, this.groupG);
    }

    @Override
    public ElgamalPublicKey restoreEncryptionKey(Representation repr) {
        return new ElgamalPublicKey(repr, this.groupG);
    }

    @Override
    public ElgamalPrivateKey restoreDecryptionKey(Representation repr) {
        return new ElgamalPrivateKey(repr, this);
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElgamalEncryption other = (ElgamalEncryption)o;
        return Objects.equals(this.groupG, other.groupG);
    }

    public int hashCode() {
        return this.groupG != null ? this.groupG.hashCode() : 0;
    }
}

