/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma.instance;

import org.cryptimeleon.craco.protocols.CommonInput;
import org.cryptimeleon.craco.protocols.SecretInput;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocol;
import org.cryptimeleon.craco.protocols.arguments.sigma.instance.SigmaProtocolInstance;
import org.cryptimeleon.math.serialization.Representation;

public class SigmaProtocolProverInstance
extends SigmaProtocolInstance {
    protected State state = State.NOTHING;

    public SigmaProtocolProverInstance(SigmaProtocol protocol, CommonInput commonInput, SecretInput secretInput) {
        super(protocol, commonInput, secretInput);
    }

    @Override
    public String getRoleName() {
        return "prover";
    }

    @Override
    public Representation nextMessage(Representation received) {
        switch (this.state) {
            case NOTHING: {
                this.announcementSecret = this.protocol.generateAnnouncementSecret(this.commonInput, this.secretInput);
                this.announcement = this.protocol.generateAnnouncement(this.commonInput, this.secretInput, this.announcementSecret);
                this.state = State.SENT_ANNOUNCEMENT;
                return this.announcement.getRepresentation();
            }
            case SENT_ANNOUNCEMENT: {
                this.challenge = this.protocol.restoreChallenge(this.commonInput, received);
                this.state = State.SENT_RESPONSE;
                this.response = this.protocol.generateResponse(this.commonInput, this.secretInput, this.announcement, this.announcementSecret, this.challenge);
                return this.response.getRepresentation();
            }
            case SENT_RESPONSE: {
                return null;
            }
        }
        throw new IllegalStateException("Unexpected state for Sigma protocol instance: " + this.state.toString());
    }

    @Override
    public boolean hasTerminated() {
        return this.state == State.SENT_RESPONSE;
    }

    public static enum State {
        NOTHING,
        SENT_ANNOUNCEMENT,
        SENT_RESPONSE;

    }
}

