/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma.partial;

import org.cryptimeleon.craco.protocols.CommonInput;
import org.cryptimeleon.craco.protocols.SecretInput;
import org.cryptimeleon.craco.protocols.arguments.sigma.Announcement;
import org.cryptimeleon.craco.protocols.arguments.sigma.AnnouncementSecret;
import org.cryptimeleon.craco.protocols.arguments.sigma.Challenge;
import org.cryptimeleon.craco.protocols.arguments.sigma.ChallengeSpace;
import org.cryptimeleon.craco.protocols.arguments.sigma.Response;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocol;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocolTranscript;
import org.cryptimeleon.math.expressions.bool.BooleanExpression;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.cartesian.Vector;

public class AndProof
implements SigmaProtocol {
    public final Vector<SigmaProtocol> protocols;

    public AndProof(SigmaProtocol ... protocols) {
        this.protocols = new Vector((Object[])protocols);
    }

    @Override
    public AnnouncementSecret generateAnnouncementSecret(CommonInput commonInput, SecretInput secretInput) {
        return (AnnouncementSecret)this.protocols.map((i, protocol) -> protocol.generateAnnouncementSecret((CommonInput)((CommonInput.CommonInputVector)commonInput).get((int)i), (SecretInput)((SecretInput.SecretInputVector)secretInput).get((int)i)), AnnouncementSecret.AnnouncementSecretVector::new);
    }

    @Override
    public Announcement generateAnnouncement(CommonInput commonInput, SecretInput secretInput, AnnouncementSecret announcementSecret) {
        return (Announcement)this.protocols.map((i, protocol) -> protocol.generateAnnouncement((CommonInput)((CommonInput.CommonInputVector)commonInput).get((int)i), (SecretInput)((SecretInput.SecretInputVector)secretInput).get((int)i), (AnnouncementSecret)((AnnouncementSecret.AnnouncementSecretVector)announcementSecret).get((int)i)), Announcement.AnnouncementVector::new);
    }

    @Override
    public ChallengeSpace getChallengeSpace(CommonInput commonInput) {
        ChallengeSpace challengeSpace = ((SigmaProtocol)this.protocols.get(0)).getChallengeSpace((CommonInput)((CommonInput.CommonInputVector)commonInput).get(0));
        if (this.protocols.stream().map(p -> p.getChallengeSpace(commonInput)).anyMatch(cs -> !cs.equals(challengeSpace))) {
            throw new IllegalStateException("Challenge spaces of subprotocols inconsistent.");
        }
        return challengeSpace;
    }

    @Override
    public Response generateResponse(CommonInput commonInput, SecretInput secretInput, Announcement announcement, AnnouncementSecret announcementSecret, Challenge challenge) {
        return (Response)this.protocols.map((i, protocol) -> protocol.generateResponse((CommonInput)((CommonInput.CommonInputVector)commonInput).get((int)i), (SecretInput)((SecretInput.SecretInputVector)secretInput).get((int)i), (Announcement)((Announcement.AnnouncementVector)announcement).get((int)i), (AnnouncementSecret)((AnnouncementSecret.AnnouncementSecretVector)announcementSecret).get((int)i), challenge), Response.ResponseVector::new);
    }

    @Override
    public BooleanExpression checkTranscriptAsExpression(CommonInput commonInput, Announcement announcement, Challenge challenge, Response response) {
        return (BooleanExpression)this.protocols.map((i, protocol) -> protocol.checkTranscriptAsExpression((CommonInput)((CommonInput.CommonInputVector)commonInput).get((int)i), (Announcement)((Announcement.AnnouncementVector)announcement).get((int)i), challenge, (Response)((Response.ResponseVector)response).get((int)i))).reduce(BooleanExpression::and, (Object)BooleanExpression.TRUE);
    }

    @Override
    public SigmaProtocolTranscript generateSimulatedTranscript(CommonInput commonInput, Challenge challenge) {
        Vector transcriptVector = this.protocols.map((i, protocol) -> protocol.generateSimulatedTranscript((CommonInput)((CommonInput.CommonInputVector)commonInput).get((int)i), challenge));
        Announcement.AnnouncementVector announcement = (Announcement.AnnouncementVector)transcriptVector.map(SigmaProtocolTranscript::getAnnouncement, Announcement.AnnouncementVector::new);
        Response.ResponseVector response = (Response.ResponseVector)transcriptVector.map(SigmaProtocolTranscript::getResponse, Response.ResponseVector::new);
        return new SigmaProtocolTranscript(announcement, challenge, response);
    }

    @Override
    public Announcement restoreAnnouncement(CommonInput commonInput, Representation repr) {
        return (Announcement)this.protocols.map((i, protocol) -> protocol.restoreAnnouncement((CommonInput)((CommonInput.CommonInputVector)commonInput).get((int)i), repr.list().get(i.intValue())), Announcement.AnnouncementVector::new);
    }

    @Override
    public Response restoreResponse(CommonInput commonInput, Announcement announcement, Challenge challenge, Representation repr) {
        return (Response)this.protocols.map((i, protocol) -> protocol.restoreResponse((CommonInput)((CommonInput.CommonInputVector)commonInput).get((int)i), (Announcement)((Announcement.AnnouncementVector)announcement).get((int)i), challenge, repr.list().get(i.intValue())), Response.ResponseVector::new);
    }

    @Override
    public void debugProof(CommonInput commonInput, SecretInput secretInput) {
        this.protocols.forEach((i, protocol) -> {
            try {
                this.debugProof((CommonInput)((CommonInput.CommonInputVector)commonInput).get((int)i), (SecretInput)((SecretInput.SecretInputVector)secretInput).get((int)i));
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error in " + i + "th protocol in the AND proof", e);
            }
        });
    }
}

