/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.secretsharing.accessstructure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.cryptimeleon.craco.common.policies.Policy;
import org.cryptimeleon.craco.common.policies.PolicyFact;
import org.cryptimeleon.craco.secretsharing.accessstructure.AccessStructure;
import org.cryptimeleon.craco.secretsharing.accessstructure.exceptions.NoSatisfyingSet;
import org.cryptimeleon.craco.secretsharing.accessstructure.exceptions.WrongAccessStructureException;
import org.cryptimeleon.craco.secretsharing.accessstructure.utils.ComparablePair;
import org.cryptimeleon.craco.secretsharing.accessstructure.utils.TreeNode;
import org.cryptimeleon.craco.secretsharing.accessstructure.visitors.MinimalFulfillingSubsetVisitor;
import org.cryptimeleon.craco.secretsharing.accessstructure.visitors.MonotoneSpanProgramGetMatrixVisitor;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class MonotoneSpanProgram
extends AccessStructure {
    public MonotoneSpanProgram(Policy policy, Zp field) {
        super(policy, field);
    }

    @Override
    public Map<Integer, Zp.ZpElement> getShares(Zp.ZpElement secret) throws WrongAccessStructureException {
        ArrayList<ArrayList<Zp.ZpElement>> matrix = new ArrayList<ArrayList<Zp.ZpElement>>();
        int size = this.generateMatrix(matrix);
        ArrayList<Zp.ZpElement> randomVector = new ArrayList<Zp.ZpElement>();
        randomVector.add(secret);
        for (int counter = 1; counter < size; ++counter) {
            randomVector.add(this.field.getUniformlyRandomElement());
        }
        HashMap<Integer, Zp.ZpElement> result = new HashMap<Integer, Zp.ZpElement>();
        int counter = 0;
        for (ArrayList<Zp.ZpElement> row : matrix) {
            Iterator iteratorVector = randomVector.iterator();
            Zp.ZpElement value = this.field.getZeroElement();
            for (Zp.ZpElement entry : row) {
                value = value.add((Element)entry.mul((Element)iteratorVector.next()));
            }
            result.put(counter, value);
            ++counter;
        }
        return result;
    }

    public int getNumberOfColumns() throws WrongAccessStructureException {
        ArrayList<ArrayList<Zp.ZpElement>> convert = new ArrayList<ArrayList<Zp.ZpElement>>();
        return this.generateMatrix(convert);
    }

    @Override
    public Map<Integer, Zp.ZpElement> getSolvingVector(Set<? extends PolicyFact> setOfParties) throws NoSatisfyingSet, WrongAccessStructureException {
        TreeNode tree = this.thresholdTree;
        MinimalFulfillingSubsetVisitor minimalSubsetVisitor = new MinimalFulfillingSubsetVisitor(this.getSharesOfReceivers(setOfParties));
        ComparablePair<Integer, ArrayList<Integer>> fulfillingSet = tree.performVisitor(minimalSubsetVisitor);
        if (fulfillingSet.getFirst() == 0) {
            throw new NoSatisfyingSet("Given set does not satisfy the access structure");
        }
        int numberOfRows = fulfillingSet.getFirst();
        ArrayList<ArrayList<Zp.ZpElement>> convert = new ArrayList<ArrayList<Zp.ZpElement>>();
        Zp.ZpElement[][] matrix = this.convertRepresentationOfMatrix(this.generateMatrix(convert), convert);
        Zp.ZpElement[][] submatrix = new Zp.ZpElement[numberOfRows][];
        Integer[] labeling = new Integer[numberOfRows];
        int counter = 0;
        Iterator<Integer> iterator = fulfillingSet.getSecond().iterator();
        while (iterator.hasNext()) {
            Integer id;
            labeling[counter] = id = iterator.next();
            submatrix[counter++] = matrix[id];
        }
        Zp.ZpElement[] vector = this.calculateSolvingVector(submatrix);
        HashMap<Integer, Zp.ZpElement> result = new HashMap<Integer, Zp.ZpElement>();
        int i = 0;
        for (Zp.ZpElement ele : vector) {
            result.put(labeling[i], ele);
            ++i;
        }
        return result;
    }

    public String toStringFor3DigitsGates() throws WrongAccessStructureException {
        ArrayList<ArrayList<Zp.ZpElement>> matrix = new ArrayList<ArrayList<Zp.ZpElement>>();
        int size = this.generateMatrix(matrix);
        String output = "";
        int rowCounter = 0;
        int columnCounter = 0;
        for (ArrayList<Zp.ZpElement> row : matrix) {
            columnCounter = 0;
            output = output.concat("( ");
            for (Zp.ZpElement entry : row) {
                ++columnCounter;
                output = output.concat(String.format("%3d ", entry.asInteger().shortValue()));
            }
            while (columnCounter <= size) {
                output = output.concat(String.format("%3d ", 0));
                ++columnCounter;
            }
            output = output.concat(String.format(") %s\n", ((PolicyFact)this.shareReceivers.get(rowCounter++)).toString()));
        }
        return output;
    }

    private Zp.ZpElement[] calculateSolvingVector(Zp.ZpElement[][] matrix) throws NoSatisfyingSet {
        int i;
        int numberOfRows = matrix.length;
        int numberOfColumns = matrix[0].length;
        int counterRows = 0;
        int counterColumns = numberOfColumns - 1;
        Zp.ZpElement[][] vectors = new Zp.ZpElement[numberOfRows][];
        for (i = 0; i < numberOfRows; ++i) {
            Zp.ZpElement[] vector = new Zp.ZpElement[numberOfRows];
            for (int j = 0; j < numberOfRows; ++j) {
                vector[j] = j == i ? this.field.getOneElement() : this.field.getZeroElement();
            }
            vectors[i] = vector;
        }
        while (counterRows != numberOfRows && counterColumns != -1) {
            if (matrix[counterRows][counterColumns].equals((Object)this.field.getZeroElement())) {
                for (i = counterRows + 1; i < numberOfRows && matrix[i][counterColumns].equals((Object)this.field.getZeroElement()); ++i) {
                }
                if (i == numberOfRows) {
                    --counterColumns;
                    continue;
                }
                this.swapRows(vectors, matrix, i, counterRows);
            }
            for (int j = counterRows + 1; j < numberOfRows; ++j) {
                this.subtractRowIFromRowJ(vectors, matrix, counterColumns, counterRows, j);
            }
            --counterColumns;
            ++counterRows;
        }
        if (counterColumns != -1 || matrix[--counterRows][0].equals((Object)this.field.getZeroElement())) {
            throw new NoSatisfyingSet("Given set does not satisfy the access structure");
        }
        for (int k = 0; k < vectors[0].length; ++k) {
            vectors[counterRows][k] = vectors[counterRows][k].div((Element)matrix[counterRows][0]);
        }
        return vectors[counterRows];
    }

    private Zp.ZpElement[][] convertRepresentationOfMatrix(int size, ArrayList<ArrayList<Zp.ZpElement>> matrix) {
        int i = 0;
        int j = 0;
        Zp.ZpElement[][] result = new Zp.ZpElement[matrix.size()][size];
        Zp.ZpElement zero = this.field.getZeroElement();
        for (ArrayList<Zp.ZpElement> row : matrix) {
            j = 0;
            Iterator<Zp.ZpElement> iterator = row.iterator();
            while (iterator.hasNext()) {
                Zp.ZpElement entry;
                result[i][j] = entry = iterator.next();
                ++j;
            }
            while (j < size) {
                result[i][j] = zero = this.field.getZeroElement();
                ++j;
            }
            ++i;
        }
        return result;
    }

    private Integer generateMatrix(ArrayList<ArrayList<Zp.ZpElement>> matrix) throws WrongAccessStructureException {
        ArrayList<Zp.ZpElement> prefix = new ArrayList<Zp.ZpElement>();
        prefix.add(this.field.getOneElement());
        MonotoneSpanProgramGetMatrixVisitor visitor = new MonotoneSpanProgramGetMatrixVisitor(this.field, prefix, matrix);
        this.thresholdTree.performVisitor(visitor);
        return visitor.getResultOfCurrentNode() + 1;
    }

    private void subtractRowIFromRowJ(Zp.ZpElement[][] vectors, Zp.ZpElement[][] matrix, int column, int i, int j) {
        int k;
        Zp.ZpElement factor = this.field.getOneElement().div((Element)matrix[i][column]).mul((Element)matrix[j][column]);
        for (k = 0; k < vectors[0].length; ++k) {
            vectors[j][k] = vectors[j][k].sub((Element)factor.mul((Element)vectors[i][k]));
        }
        for (k = 0; k < matrix[0].length; ++k) {
            matrix[j][k] = matrix[j][k].sub((Element)factor.mul((Element)matrix[i][k]));
        }
    }

    private void swapRows(Zp.ZpElement[][] vectors, Zp.ZpElement[][] matrix, int i, int j) {
        Zp.ZpElement[] tempVector = vectors[i];
        Zp.ZpElement[] tempRow = matrix[i];
        vectors[i] = vectors[j];
        matrix[i] = matrix[j];
        vectors[j] = tempVector;
        matrix[j] = tempRow;
    }

    public HashMap<Integer, PolicyFact> getAttributes() {
        return this.shareReceivers;
    }

    @Override
    public Map<Integer, Zp.ZpElement> completeShares(Zp.ZpElement secret, Map<Integer, Zp.ZpElement> partialShares) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean checkShareConsistency(Zp.ZpElement secret, Map<Integer, Zp.ZpElement> shares) {
        throw new UnsupportedOperationException();
    }
}

