/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig;

import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.math.structures.cartesian.Vector;

public interface MultiMessageSignatureScheme
extends SignatureScheme {
    default public Signature sign(SigningKey secretKey, PlainText ... plainTexts) {
        return this.sign(new MessageBlock(plainTexts), secretKey);
    }

    default public Boolean verify(VerificationKey publicKey, Signature signature, PlainText ... plainTexts) {
        return this.verify(new MessageBlock(plainTexts), signature, publicKey);
    }

    default public Signature sign(SigningKey secretKey, Vector<? extends PlainText> plainTexts) {
        return this.sign(new MessageBlock(plainTexts), secretKey);
    }

    default public Boolean verify(VerificationKey publicKey, Signature signature, Vector<? extends PlainText> plainTexts) {
        return this.verify(new MessageBlock(plainTexts), signature, publicKey);
    }
}

