/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.bbs;

import java.util.Objects;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class BBSABSignature
implements Signature {
    @Represented(restorer="G1")
    private GroupElement elementA;
    @Represented(restorer="Zp")
    private Zn.ZnElement exponentX;
    @Represented(restorer="Zp")
    private Zn.ZnElement exponentS;

    public BBSABSignature(Representation repr, Group groupG1) {
        new ReprUtil((Object)this).register((RepresentationRestorer)groupG1, "G1").register((RepresentationRestorer)new Zn(groupG1.size()), "Zp").deserialize(repr);
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public BBSABSignature(GroupElement elementA, Zn.ZnElement exponentX, Zn.ZnElement exponentS) {
        this.elementA = elementA;
        this.exponentX = exponentX;
        this.exponentS = exponentS;
    }

    public GroupElement getElementA() {
        return this.elementA;
    }

    public void setElementA(GroupElement elementA) {
        this.elementA = elementA;
    }

    public Zn.ZnElement getExponentX() {
        return this.exponentX;
    }

    public void setExponentX(Zn.ZnElement exponentX) {
        this.exponentX = exponentX;
    }

    public Zn.ZnElement getExponentS() {
        return this.exponentS;
    }

    public void setExponentS(Zn.ZnElement exponentS) {
        this.exponentS = exponentS;
    }

    public String toString() {
        return "BBSABSignature [elementA=" + this.elementA + ", exponentX=" + this.exponentX + ", exponentS=" + this.exponentS + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elementA == null ? 0 : this.elementA.hashCode());
        result = 31 * result + (this.exponentS == null ? 0 : this.exponentS.hashCode());
        result = 31 * result + (this.exponentX == null ? 0 : this.exponentX.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BBSABSignature other = (BBSABSignature)obj;
        return Objects.equals(this.elementA, other.elementA) && Objects.equals(this.exponentS, other.exponentS) && Objects.equals(this.exponentX, other.exponentX);
    }
}

