/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.ps;

import java.util.Objects;
import org.cryptimeleon.craco.protocols.SecretInput;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.rings.cartesian.RingElementVector;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class PSSigningKey
implements SigningKey,
SecretInput {
    @Represented(restorer="Zp")
    protected Zp.ZpElement exponentX;
    @Represented(restorer="Zp")
    protected RingElementVector exponentsYi;

    public PSSigningKey(Zp.ZpElement exponentX, RingElementVector exponentsYi) {
        this.exponentX = exponentX;
        this.exponentsYi = exponentsYi;
    }

    public PSSigningKey(Representation repr, Zp zp) {
        new ReprUtil((Object)this).register((RepresentationRestorer)zp, "Zp").deserialize(repr);
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public Zp.ZpElement getExponentX() {
        return this.exponentX;
    }

    public RingElementVector getExponentsYi() {
        return this.exponentsYi;
    }

    public int getNumberOfMessages() {
        return this.exponentsYi.length();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PSSigningKey that = (PSSigningKey)o;
        return Objects.equals(this.exponentX, that.exponentX) && this.exponentsYi.equals((Object)that.exponentsYi);
    }

    public int hashCode() {
        int result = Objects.hash(this.exponentX);
        result = 31 * result + this.exponentsYi.hashCode();
        return result;
    }
}

